/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.converter;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.johnzon.mapper.Converter;

public class CachedDelegateConverter<T>
implements Converter<T> {
    private final ConcurrentMap<T, String> strings = new ConcurrentHashMap<T, String>();
    private final ConcurrentMap<String, T> values = new ConcurrentHashMap<String, T>();
    private final Converter<T> delegate;

    public CachedDelegateConverter(Converter<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String toString(T instance) {
        String v = (String)this.strings.get(instance);
        if (v == null) {
            v = this.delegate.toString(instance);
            this.strings.putIfAbsent(instance, v);
        }
        return v;
    }

    @Override
    public T fromString(String text) {
        Object v = this.values.get(text);
        if (v == null) {
            v = this.delegate.fromString(text);
            this.values.putIfAbsent(text, v);
        }
        return (T)v;
    }
}

