/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;

public class SchemaObjectSet {
    static final int addErrorCode = 5504;
    static final int getErrorCode = 5501;
    private final OrderedHashMap<String, SchemaObject> map;
    private final OrderedHashMap<String, HsqlNameManager.HsqlName> nameMap;
    private final int type;

    SchemaObjectSet(int n) {
        this.type = n;
        switch (n) {
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                this.map = new OrderedHashMap();
                this.nameMap = null;
                break;
            }
            case 5: 
            case 20: {
                this.map = null;
                this.nameMap = new OrderedHashMap();
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaObjectSet");
            }
        }
    }

    OrderedHashMap<String, ? extends SchemaObject> getMap() {
        return this.map;
    }

    HsqlNameManager.HsqlName getName(String string) {
        switch (this.type) {
            default: {
                SchemaObject schemaObject = (SchemaObject)this.map.get((Object)string);
                return schemaObject == null ? null : schemaObject.getName();
            }
            case 5: 
            case 20: 
        }
        return (HsqlNameManager.HsqlName)this.nameMap.get((Object)string);
    }

    public SchemaObject getObject(String string) {
        switch (this.type) {
            default: {
                return (SchemaObject)this.map.get((Object)string);
            }
            case 5: 
            case 20: 
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    public Iterator<SchemaObject> getIterator() {
        switch (this.type) {
            default: {
                return this.map.values().iterator();
            }
            case 5: 
            case 20: 
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    public Iterator<HsqlNameManager.HsqlName> getNameIterator() {
        switch (this.type) {
            default: {
                return this.nameIterator(this.map.values().iterator());
            }
            case 5: 
            case 20: 
        }
        return this.nameMap.values().iterator();
    }

    private Iterator<HsqlNameManager.HsqlName> nameIterator(final Iterator<SchemaObject> iterator) {
        return new Iterator<HsqlNameManager.HsqlName>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public HsqlNameManager.HsqlName next() {
                return ((SchemaObject)iterator.next()).getName();
            }
        };
    }

    public boolean contains(String string) {
        return this.map.containsKey(string);
    }

    void checkAdd(HsqlNameManager.HsqlName hsqlName) {
        switch (this.type) {
            default: {
                if (!this.map.containsKey(hsqlName.name)) break;
                throw Error.error(5504, hsqlName.name);
            }
            case 5: 
            case 20: {
                if (!this.nameMap.containsKey(hsqlName.name)) break;
                throw Error.error(5504, hsqlName.name);
            }
        }
    }

    void checkExists(String string) {
        switch (this.type) {
            default: {
                if (this.map.containsKey(string)) break;
                throw Error.error(5501, string);
            }
            case 5: 
            case 20: {
                if (this.nameMap.containsKey(string)) break;
                throw Error.error(5501, string);
            }
        }
    }

    boolean isEmpty() {
        switch (this.type) {
            default: {
                return this.map.isEmpty();
            }
            case 5: 
            case 20: 
        }
        return this.nameMap.isEmpty();
    }

    public void add(SchemaObject schemaObject, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (this.type == 24) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        switch (this.type) {
            default: {
                if (!bl && this.map.containsKey(hsqlName.name)) {
                    throw Error.error(5504, hsqlName.name);
                }
                this.map.put(hsqlName.name, schemaObject);
                break;
            }
            case 5: 
            case 20: {
                if (!bl && this.nameMap.containsKey(hsqlName.name)) {
                    throw Error.error(5504, hsqlName.name);
                }
                this.nameMap.put(hsqlName.name, hsqlName);
            }
        }
    }

    void remove(String string) {
        switch (this.type) {
            default: {
                this.map.remove(string);
                break;
            }
            case 5: 
            case 20: {
                this.nameMap.remove(string);
            }
        }
    }

    void removeParent(HsqlNameManager.HsqlName hsqlName) {
        switch (this.type) {
            default: {
                Iterator iterator = this.map.values().iterator();
                while (iterator.hasNext()) {
                    SchemaObject schemaObject = (SchemaObject)iterator.next();
                    if (!schemaObject.getName().parent.equals(hsqlName)) continue;
                    iterator.remove();
                }
                break;
            }
            case 5: 
            case 20: {
                Iterator iterator = this.nameMap.values().iterator();
                while (iterator.hasNext()) {
                    HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
                    if (!hsqlName2.parent.equals(hsqlName)) continue;
                    iterator.remove();
                }
                break block0;
            }
        }
    }

    void rename(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        switch (hsqlName2.type) {
            default: {
                SchemaObject schemaObject = (SchemaObject)this.map.get((Object)hsqlName.name);
                if (schemaObject == null) {
                    throw Error.error(5501, hsqlName.name);
                }
                HsqlNameManager.HsqlName hsqlName3 = this.type == 24 ? ((Routine)schemaObject).getSpecificName() : schemaObject.getName();
                if (this.map.containsKey(hsqlName2.name)) {
                    throw Error.error(5504, hsqlName2.name);
                }
                int n = this.map.getIndex(hsqlName.name);
                this.map.setKeyAt(n, hsqlName2.name);
                hsqlName3.rename(hsqlName2);
                break;
            }
            case 5: 
            case 20: {
                HsqlNameManager.HsqlName hsqlName4 = (HsqlNameManager.HsqlName)this.nameMap.get((Object)hsqlName.name);
                if (hsqlName4 == null) {
                    throw Error.error(5501, hsqlName.name);
                }
                if (this.nameMap.containsKey(hsqlName2.name)) {
                    throw Error.error(5504, hsqlName2.name);
                }
                int n = this.nameMap.getIndex(hsqlName.name);
                this.nameMap.setKeyAt(n, hsqlName2.name);
                hsqlName4.rename(hsqlName2);
                break;
            }
        }
    }

    public static String getName(int n) {
        switch (n) {
            case 6: {
                return "ASSERTION";
            }
            case 14: {
                return "CHARACTER SET";
            }
            case 15: {
                return "COLLATION";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 13: {
                return "DOMAIN";
            }
            case 32: {
                return "EXCEPTION";
            }
            case 16: {
                return "FUNCTION";
            }
            case 20: {
                return "INDEX";
            }
            case 31: {
                return "MODULE";
            }
            case 23: {
                return "PARAMETER";
            }
            case 30: {
                return "PERIOD";
            }
            case 17: {
                return "PROCEDURE";
            }
            case 29: {
                return "SYNONYM";
            }
            case 7: {
                return "SEQUENCE";
            }
            case 24: {
                return "SPECIFIC ROUTINE";
            }
            case 3: {
                return "TABLE";
            }
            case 8: {
                return "TRIGGER";
            }
            case 12: {
                return "TYPE";
            }
            case 4: {
                return "VIEW";
            }
        }
        throw Error.runtimeError(201, "SchemaObjectSet");
    }

    void getSQL(HsqlArrayList<String> hsqlArrayList, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet, OrderedHashSet<SchemaObject> orderedHashSet2) {
        if (this.type == 5 || this.type == 20) {
            return;
        }
        if (this.map.isEmpty()) {
            return;
        }
        Iterator<SchemaObject> iterator = this.map.values().iterator();
        if (this.type == 16 || this.type == 17) {
            OrderedHashSet<Routine> orderedHashSet3 = new OrderedHashSet<Routine>();
            while (iterator.hasNext()) {
                RoutineSchema routineSchema = (RoutineSchema)iterator.next();
                for (int i = 0; i < routineSchema.routines.length; ++i) {
                    Routine routine = routineSchema.routines[i];
                    orderedHashSet3.add(routine);
                }
            }
            iterator = orderedHashSet3.iterator();
        }
        SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, iterator, null);
    }

    static void addAllSQL(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet, OrderedHashSet<SchemaObject> orderedHashSet2, HsqlArrayList<String> hsqlArrayList, Iterator<SchemaObject> iterator, OrderedHashSet<SchemaObject> orderedHashSet3) {
        block15: while (iterator.hasNext()) {
            ColumnSchema columnSchema;
            int n;
            Object object;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet4;
            SchemaObject schemaObject = iterator.next();
            boolean bl = true;
            if (schemaObject.getType() == 3) {
                ((Table)schemaObject).setForwardConstraints(orderedHashSet);
                orderedHashSet4 = ((Table)schemaObject).getReferencesForScript();
            } else {
                orderedHashSet4 = schemaObject.getReferences();
            }
            block16: for (int i = 0; i < orderedHashSet4.size(); ++i) {
                object = orderedHashSet4.get(i);
                if (SqlInvariants.isSchemaNameSystem((HsqlNameManager.HsqlName)object)) continue;
                switch (((HsqlNameManager.HsqlName)object).type) {
                    case 3: {
                        if (orderedHashSet.contains(object)) continue block16;
                        bl = false;
                        continue block16;
                    }
                    case 9: {
                        if (schemaObject.getType() == 3) {
                            n = ((Table)schemaObject).findColumn(((HsqlNameManager.HsqlName)object).name);
                            columnSchema = ((Table)schemaObject).getColumn(n);
                            if (SchemaObjectSet.isChildObjectResolved(columnSchema, orderedHashSet)) continue block16;
                            bl = false;
                            continue block16;
                        }
                        if (orderedHashSet.contains(((HsqlNameManager.HsqlName)object).parent)) continue block16;
                        bl = false;
                        continue block16;
                    }
                    case 5: {
                        Constraint constraint;
                        if (((HsqlNameManager.HsqlName)object).parent != schemaObject.getName() || (constraint = ((Table)schemaObject).getConstraint(((HsqlNameManager.HsqlName)object).name)).getConstraintType() != 3 || SchemaObjectSet.isChildObjectResolved(constraint, orderedHashSet)) continue block16;
                        bl = false;
                        continue block16;
                    }
                    case 14: {
                        if (((HsqlNameManager.HsqlName)object).schema == null) continue block16;
                    }
                    case 7: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 24: {
                        if (orderedHashSet.contains(object)) continue block16;
                        bl = false;
                        continue block16;
                    }
                }
            }
            if (!bl) {
                orderedHashSet2.add(schemaObject);
                continue;
            }
            HsqlNameManager.HsqlName hsqlName = schemaObject.getType() == 16 || schemaObject.getType() == 17 ? ((Routine)schemaObject).getSpecificName() : schemaObject.getName();
            orderedHashSet.add(hsqlName);
            if (orderedHashSet3 != null) {
                orderedHashSet3.add(schemaObject);
            }
            switch (schemaObject.getType()) {
                case 3: {
                    hsqlArrayList.addAll(((Table)schemaObject).getSQL(orderedHashSet, orderedHashSet2));
                    object = schemaObject.getName().getCommentSQL("TABLE");
                    if (object != null) {
                        hsqlArrayList.add((String)object);
                    }
                    for (n = 0; n < ((Table)schemaObject).getColumnCount(); ++n) {
                        columnSchema = ((Table)schemaObject).getColumn(n);
                        object = columnSchema.getName().getCommentSQL("COLUMN");
                        if (object == null) continue;
                        hsqlArrayList.add((String)object);
                    }
                    continue block15;
                }
                case 4: {
                    hsqlArrayList.add(schemaObject.getSQL());
                    object = schemaObject.getName().getCommentSQL("TABLE");
                    if (object == null) continue block15;
                    hsqlArrayList.add((String)object);
                    break;
                }
                case 16: 
                case 17: {
                    String string;
                    object = (Routine)schemaObject;
                    if (((Routine)object).isRecursive) {
                        hsqlArrayList.add(((Routine)schemaObject).getSQLDeclaration());
                        hsqlArrayList.add(((Routine)schemaObject).getSQLAlter());
                    } else {
                        hsqlArrayList.add(schemaObject.getSQL());
                    }
                    if ((string = schemaObject.getName().getCommentSQL("ROUTINE")) == null) continue block15;
                    hsqlArrayList.add(string);
                    break;
                }
                case 8: {
                    hsqlArrayList.add(schemaObject.getSQL());
                    object = schemaObject.getName().getCommentSQL("TRIGGER");
                    if (object == null) continue block15;
                    hsqlArrayList.add((String)object);
                    break;
                }
                case 7: {
                    hsqlArrayList.add(schemaObject.getSQL());
                    object = schemaObject.getName().getCommentSQL("SEQUENCE");
                    if (object == null) continue block15;
                    hsqlArrayList.add((String)object);
                    break;
                }
                case 5: {
                    hsqlArrayList.add(schemaObject.getSQL());
                    object = ((Constraint)schemaObject).getAlterSQL();
                    if (((String)object).isEmpty()) continue block15;
                    hsqlArrayList.add((String)object);
                    break;
                }
                default: {
                    hsqlArrayList.add(schemaObject.getSQL());
                }
            }
        }
    }

    static boolean isChildObjectResolved(SchemaObject schemaObject, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = schemaObject.getReferences();
        for (int i = 0; i < orderedHashSet2.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = orderedHashSet2.get(i);
            if (SqlInvariants.isSchemaNameSystem(hsqlName) || orderedHashSet.contains(hsqlName)) continue;
            return false;
        }
        return true;
    }
}

