/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.AsynchronousNonBlockingConfig;
import java.lang.annotation.Annotation;

public final class AsynchronousNonBlockingConfigImpl
implements AsynchronousNonBlockingConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final AsynchronousNonBlocking instance;
    private final boolean onMethod;

    private AsynchronousNonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.asynchronousNonBlocking;
        this.onMethod = method.annotationsPresentDirectly.contains(AsynchronousNonBlocking.class);
    }

    public static AsynchronousNonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.asynchronousNonBlocking == null) {
            return null;
        }
        if (!Config.isEnabled(AsynchronousNonBlocking.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new AsynchronousNonBlockingConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return AsynchronousNonBlocking.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public void materialize() {
    }
}

