/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.core.util.Durations;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface RetryConfig
extends Retry,
Config {
    default public void validate() {
        long delay;
        String INVALID_RETRY_ON = "Invalid @Retry on ";
        if (this.maxRetries() < -1) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + String.valueOf(this.method()) + ": maxRetries shouldn't be lower than -1");
        }
        if (this.delay() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + String.valueOf(this.method()) + ": delay shouldn't be lower than 0");
        }
        if (this.maxDuration() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + String.valueOf(this.method()) + ": maxDuration shouldn't be lower than 0");
        }
        long maxDuration = Durations.timeInMillis((long)this.maxDuration(), (ChronoUnit)this.durationUnit());
        if (maxDuration > 0L && maxDuration <= (delay = Durations.timeInMillis((long)this.delay(), (ChronoUnit)this.delayUnit()))) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + String.valueOf(this.method()) + ": maxDuration should be greater than delay");
        }
        if (this.jitter() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + String.valueOf(this.method()) + ": jitter shouldn't be lower than 0");
        }
    }
}

