/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;

public class TreatAsExpression
extends QueryKeyExpression {
    protected ObjectExpression typeExpressionBase;
    protected Expression typeExpression;
    protected Boolean isDowncast;

    @Override
    public Expression convertToUseOuterJoin() {
        this.typeExpressionBase.convertToUseOuterJoin();
        return this;
    }

    @Override
    public String descriptionOfNodeType() {
        return "Treat";
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        TreatAsExpression expression = (TreatAsExpression)object;
        return this.getCastClass().equals(expression.getCastClass());
    }

    @Override
    public Vector getFields() {
        return this.typeExpressionBase.getFields();
    }

    @Override
    public Object getFieldValue(Object objectValue, AbstractSession session) {
        return this.typeExpressionBase.getFieldValue(objectValue, session);
    }

    @Override
    public List<DatabaseTable> getOwnedTables() {
        return super.getOwnedTables();
    }

    @Override
    public Expression getAlias(Expression subSelect) {
        return this.typeExpressionBase.getAlias(subSelect);
    }

    @Override
    public DatabaseTable getRelationTable() {
        return null;
    }

    @Override
    public TableAliasLookup getTableAliases() {
        return this.typeExpressionBase.getTableAliases();
    }

    @Override
    public boolean hasAsOfClause() {
        return this.typeExpressionBase.hasAsOfClause();
    }

    public boolean isDowncast() {
        if (this.isDowncast == null) {
            this.getDescriptor();
        }
        return this.isDowncast;
    }

    @Override
    public boolean isTreatExpression() {
        return true;
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        this.typeExpressionBase.printSQL(printer);
    }

    @Override
    public boolean selectIfOrderedBy() {
        return this.typeExpressionBase.selectIfOrderedBy();
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        if (oldBase == null || this.typeExpressionBase == oldBase) {
            Expression twistedBase = this.typeExpressionBase.twistedForBaseAndContext(newBase, context, oldBase);
            TreatAsExpression result = (TreatAsExpression)twistedBase.treat(this.castClass);
            if (this.shouldUseOuterJoin) {
                result.doUseOuterJoin();
            }
            if (this.shouldQueryToManyRelationship) {
                result.doQueryToManyRelationship();
            }
            return result;
        }
        return this;
    }

    @Override
    public void validateNode() {
        this.typeExpressionBase.validateNode();
        this.getDescriptor();
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        return this.typeExpressionBase.valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy) {
        return this.typeExpressionBase.valueFromObject(object, session, translationRow, valueHolderPolicy);
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        if (this.castClass != null) {
            writer.write(" AS " + this.castClass.getName());
        }
    }

    @Override
    public void writeFields(ExpressionSQLPrinter printer, List<DatabaseField> newFields, SQLSelectStatement statement) {
        this.typeExpressionBase.writeFields(printer, newFields, statement);
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.typeExpressionBase != null) {
            this.typeExpressionBase.toString(writer, indent);
        } else {
            super.writeSubexpressionsTo(writer, indent);
        }
    }

    @Override
    public ClassDescriptor getLeafDescriptor(DatabaseQuery query, ClassDescriptor rootDescriptor, AbstractSession session) {
        return session.getDescriptor(this.castClass);
    }

    @Override
    public DatabaseMapping getLeafMapping(DatabaseQuery query, ClassDescriptor rootDescriptor, AbstractSession session) {
        return this.typeExpressionBase.getLeafMapping(query, rootDescriptor, session);
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        return this.typeExpressionBase.aliasForTable(table);
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.typeExpressionBase.rebuildOn(newBase);
        return newLocalBase.treat(this.castClass);
    }

    @Override
    public ClassDescriptor getDescriptor() {
        if (this.isAttribute()) {
            throw QueryException.couldNotFindCastDescriptor(this.castClass, this.getBaseExpression());
        }
        if (this.descriptor == null) {
            ClassDescriptor rootDescriptor = this.typeExpressionBase.getDescriptor();
            this.descriptor = this.convertToCastDescriptor(rootDescriptor, this.getSession());
        }
        return this.descriptor;
    }

    @Override
    public ClassDescriptor convertToCastDescriptor(ClassDescriptor rootDescriptor, AbstractSession session) {
        this.isDowncast = Boolean.FALSE;
        if (this.castClass == null || rootDescriptor == null || rootDescriptor.getJavaClass() == this.castClass) {
            return rootDescriptor;
        }
        ClassDescriptor castDescriptor = session.getClassDescriptor(this.castClass);
        if (castDescriptor == null) {
            throw QueryException.couldNotFindCastDescriptor(this.castClass, this.getBaseExpression());
        }
        if (!castDescriptor.hasInheritance()) {
            throw QueryException.castMustUseInheritance(this.getBaseExpression());
        }
        ClassDescriptor parentDescriptor = castDescriptor.getInheritancePolicy().getParentDescriptor();
        while (parentDescriptor != null) {
            if (parentDescriptor == rootDescriptor) {
                this.isDowncast = Boolean.TRUE;
                return castDescriptor;
            }
            parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
        }
        ClassDescriptor childDescriptor = rootDescriptor;
        while (childDescriptor != null) {
            if (childDescriptor == castDescriptor) {
                return rootDescriptor;
            }
            childDescriptor = childDescriptor.getInheritancePolicy().getParentDescriptor();
        }
        throw QueryException.couldNotFindCastDescriptor(this.castClass, this.getBaseExpression());
    }

    public Expression getTypeClause() {
        if (this.typeExpression == null) {
            if (this.getDescriptor() != null && this.isDowncast()) {
                InheritancePolicy ip = this.getDescriptor().getInheritancePolicy();
                if (ip.isChildDescriptor()) {
                    this.typeExpression = ip.getWithAllSubclassesExpression();
                    this.typeExpression = this.typeExpression == null ? this.typeExpressionBase.type().equal(this.getDescriptor().getJavaClass()) : this.typeExpressionBase.twist(this.typeExpression, this.typeExpressionBase);
                }
            } else {
                this.typeExpression = this.getBuilder();
            }
        }
        return this.typeExpression;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.typeExpressionBase = (ObjectExpression)this.typeExpressionBase.copiedVersionFrom(alreadyDone);
    }

    public TreatAsExpression(Class<?> castClass, ObjectExpression baseExpression) {
        this.name = "Treat as " + castClass;
        this.typeExpressionBase = baseExpression;
        if (baseExpression.isExpressionBuilder()) {
            this.baseExpression = baseExpression;
            this.shouldQueryToManyRelationship = false;
            this.hasQueryKey = false;
            this.hasMapping = false;
        } else {
            this.baseExpression = baseExpression.getBaseExpression();
        }
        this.shouldUseOuterJoin = true;
        this.castClass = castClass;
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        this.typeExpressionBase.printJava(printer);
        if (this.castClass != null) {
            printer.printString(".treat(" + this.castClass.getName() + ".class)");
        }
    }

    @Override
    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        if (this.tableAliases == null) {
            if (this.typeExpressionBase != null) {
                if (this.typeExpressionBase.getTableAliases() == null) {
                    this.typeExpressionBase.setTableAliases(new TableAliasLookup());
                }
                this.tableAliases = this.typeExpressionBase.getTableAliases();
            } else {
                this.tableAliases = new TableAliasLookup();
            }
        }
        this.tableAliases.put(alias, table);
    }

    @Override
    public int assignTableAliasesStartingAt(int initialValue) {
        List<DatabaseTable> ownedTables;
        if (this.hasBeenAliased()) {
            return initialValue;
        }
        int counter = initialValue;
        if (this.typeExpressionBase != null) {
            counter = this.typeExpressionBase.assignTableAliasesStartingAt(counter);
        }
        if ((ownedTables = this.getOwnedSubTables()) != null) {
            for (DatabaseTable table : ownedTables) {
                this.assignAlias("t" + counter, table);
                ++counter;
            }
        }
        this.hasBeenAliased = true;
        return counter;
    }

    public List<DatabaseTable> getOwnedSubTables() {
        ClassDescriptor parentDescriptor = this.typeExpressionBase.getDescriptor();
        Vector<DatabaseTable> childTables = new Vector<DatabaseTable>(2);
        if (parentDescriptor.hasInheritance() && parentDescriptor.getInheritancePolicy().hasMultipleTableChild()) {
            List<DatabaseTable> parentTables = this.typeExpressionBase.getOwnedTables();
            Vector<DatabaseTable> tables = this.getDescriptor().getTables();
            for (DatabaseTable table : tables) {
                if (parentTables.contains(table)) continue;
                childTables.add(table);
            }
        }
        return childTables;
    }

    @Override
    public List<DatabaseTable> getAdditionalTables() {
        return null;
    }

    @Override
    public Expression mappingCriteria(Expression base) {
        if (this.typeExpressionBase.isQueryKeyExpression()) {
            return ((QueryKeyExpression)this.typeExpressionBase).mappingCriteria(base);
        }
        return null;
    }

    public Map additionalTreatExpressionCriteriaMap() {
        Expression joinExpression;
        DatabaseTable table;
        int i;
        if (this.getDescriptor() == null) {
            return null;
        }
        int tableSize = 0;
        HashMap<DatabaseTable, Expression> tablesJoinExpressions = new HashMap<DatabaseTable, Expression>();
        ClassDescriptor parentDescriptor = this.typeExpressionBase.getDescriptor();
        if (parentDescriptor.hasInheritance() && parentDescriptor.getInheritancePolicy().hasMultipleTableChild()) {
            Vector<DatabaseTable> tables = this.getDescriptor().getTables();
            tableSize = tables.size();
            for (i = 0; i < tableSize; ++i) {
                table = tables.elementAt(i);
                joinExpression = parentDescriptor.getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                if (joinExpression == null) continue;
                joinExpression = this.baseExpression.twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            List<DatabaseTable> childrenTables = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            tableSize = childrenTables.size();
            for (i = 0; i < tableSize; ++i) {
                table = childrenTables.get(i);
                joinExpression = this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                joinExpression = this.baseExpression.twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        return tablesJoinExpressions;
    }

    public Expression getTreatCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression criteria = null;
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
            Vector<DatabaseTable> tables = this.getDescriptor().getTables();
            ClassDescriptor parentDescriptor = this.typeExpressionBase.getDescriptor();
            int tablesSize = tables.size();
            if (parentDescriptor.hasInheritance() && parentDescriptor.getInheritancePolicy().hasMultipleTableChild()) {
                for (int i = 0; i < tablesSize; ++i) {
                    DatabaseTable table = tables.elementAt(i);
                    Expression joinExpression = parentDescriptor.getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                    if (joinExpression == null) continue;
                    joinExpression = this.baseExpression.twist(joinExpression, this);
                    if (this.shouldUseOuterJoin()) {
                        joinExpression = joinExpression.convertToUseOuterJoin();
                    }
                    criteria = joinExpression.and(criteria);
                }
            }
        }
        return criteria;
    }

    public Expression additionalTreatExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression criteria = null;
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            criteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            criteria = this.baseExpression.twist(criteria, this);
            criteria.convertToUseOuterJoin();
        }
        return criteria;
    }

    @Override
    public DatabaseTable getSourceTable() {
        return null;
    }

    @Override
    public DatabaseTable getReferenceTable() {
        return null;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer, Expression base, List<Expression> foreignKeyJoinPointer) {
        Map additionalExpMap;
        Integer postition;
        if (this.hasBeenNormalized) {
            return this;
        }
        this.hasBeenNormalized = true;
        Expression typeExpression = this.getTypeClause();
        typeExpression.normalize(normalizer);
        if (this.baseExpression != null) {
            this.setBaseExpression(this.baseExpression.normalize(normalizer));
            if (this.getAsOfClause() == null) {
                this.asOf(this.baseExpression.getAsOfClause());
            }
        }
        this.validateNode();
        SQLSelectStatement statement = normalizer.getStatement();
        this.typeExpressionBase = (ObjectExpression)this.typeExpressionBase.normalize(normalizer);
        if (this.onClause != null) {
            this.onClause = this.onClause.normalize(normalizer);
        }
        ClassDescriptor parentDescriptor = this.typeExpressionBase.getDescriptor();
        boolean isSTI = this.getOwnedSubTables().isEmpty();
        if (isSTI) {
            if (foreignKeyJoinPointer != null) {
                foreignKeyJoinPointer.add(typeExpression.and(this.onClause));
            } else {
                normalizer.addAdditionalLocalExpression(typeExpression.and(this.onClause));
            }
            return this;
        }
        Expression treatJoinTableExpressions = this.getTreatCriteria();
        boolean parentUsingOuterJoinForMultitableInheritance = this.typeExpressionBase.isUsingOuterJoinForMultitableInheritance();
        if (treatJoinTableExpressions != null) {
            treatJoinTableExpressions = treatJoinTableExpressions.normalize(normalizer);
        }
        if ((postition = this.typeExpressionBase.getOuterJoinExpIndex()) != null) {
            if (parentUsingOuterJoinForMultitableInheritance) {
                return this;
            }
            if (this.getSession().getPlatform().isInformixOuterJoin()) {
                normalizer.addAdditionalLocalExpression(typeExpression.and(this.additionalTreatExpressionCriteria()).and(this.onClause));
                return this;
            }
            if (!this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() || !this.getSession().getPlatform().shouldPrintInnerJoinInWhereClause(normalizer.getStatement().getParentStatement() != null ? normalizer.getStatement().getParentStatement().getQuery() : normalizer.getStatement().getQuery())) {
                Map<DatabaseTable, Expression> map = statement.getOuterJoinExpressionsHolders().get((int)postition.intValue()).outerJoinedAdditionalJoinCriteria;
                if (map != null) {
                    map.putAll(this.additionalTreatExpressionCriteriaMap());
                } else {
                    statement.getOuterJoinExpressionsHolders().get((int)postition.intValue()).outerJoinedAdditionalJoinCriteria = this.additionalTreatExpressionCriteriaMap();
                }
                return this;
            }
        } else if (!(this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.getSession().getPlatform().shouldPrintInnerJoinInWhereClause(normalizer.getStatement().getParentStatement() != null ? normalizer.getStatement().getParentStatement().getQuery() : normalizer.getStatement().getQuery()) || (additionalExpMap = this.additionalTreatExpressionCriteriaMap()) == null || additionalExpMap.isEmpty())) {
            statement.addOuterJoinExpressionsHolders(additionalExpMap, parentDescriptor);
        }
        typeExpression = typeExpression.normalize(normalizer);
        if (foreignKeyJoinPointer != null) {
            foreignKeyJoinPointer.add(typeExpression.and(this.onClause));
        } else {
            normalizer.addAdditionalLocalExpression(typeExpression.and(this.additionalTreatExpressionCriteria()).and(this.onClause));
        }
        return this;
    }
}

