/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.nosql;

import jakarta.persistence.Table;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

public class NoSqlMetadata
extends ORMetadata {
    private String dataType;
    private String dataFormat;

    public NoSqlMetadata() {
        super("<eis>");
    }

    public NoSqlMetadata(MetadataAnnotation struct, MetadataAccessor accessor) {
        super(struct, accessor);
        this.dataType = struct.getAttributeString("dataType");
        this.dataFormat = struct.getAttributeString("dataFormat");
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDataType() {
        return this.dataType;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NoSqlMetadata) {
            NoSqlMetadata eis = (NoSqlMetadata)objectToCompare;
            if (!this.valuesMatch(this.dataType, eis.getDataType())) {
                return false;
            }
            return this.valuesMatch(this.dataFormat, eis.getDataFormat());
        }
        return false;
    }

    public int hashCode() {
        int result = this.dataType != null ? this.dataType.hashCode() : 0;
        result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
        return result;
    }

    public void process(MetadataDescriptor descriptor) {
        ClassDescriptor oldDesriptor = descriptor.getClassDescriptor();
        EISDescriptor newDescriptor = new EISDescriptor();
        newDescriptor.setJavaClassName(oldDesriptor.getJavaClassName());
        if (this.dataType != null) {
            newDescriptor.setDataTypeName(this.getDataType());
        } else {
            String defaultName = Helper.getShortClassName(descriptor.getJavaClassName());
            String string = defaultName = this.getProject().useDelimitedIdentifier() ? defaultName : defaultName.toUpperCase();
            if (!descriptor.isEmbeddable()) {
                MetadataAnnotation tableAnnotation = descriptor.getEntityAccessor().getAnnotation(Table.class);
                if (tableAnnotation != null) {
                    TableMetadata tableMetadata = new TableMetadata(tableAnnotation, descriptor.getEntityAccessor());
                    newDescriptor.setDataTypeName(tableMetadata.getName());
                } else {
                    newDescriptor.setDataTypeName(defaultName);
                }
            }
        }
        if (this.dataFormat != null) {
            if (this.dataFormat.equals("XML")) {
                newDescriptor.setDataFormat("xml");
            } else if (this.dataFormat.equals("MAPPED")) {
                newDescriptor.setDataFormat("mapped");
            } else if (this.dataFormat.equals("INDEXED")) {
                newDescriptor.setDataFormat("indexed");
            }
        }
        newDescriptor.setAlias("");
        newDescriptor.getQueryManager().checkDatabaseForDoesExist();
        if (oldDesriptor.isAggregateDescriptor()) {
            newDescriptor.descriptorIsAggregate();
        }
        descriptor.setDescriptor(newDescriptor);
        descriptor.getProject().getProject().getOrderedDescriptors().remove(oldDesriptor);
        descriptor.getProject().getProject().getOrderedDescriptors().add(newDescriptor);
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}

