/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.keys;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.microprofile.jwt.JWTLogCategories;

public class UrlLocation
implements Supplier<byte[]> {
    static final Logger LOG = Logger.getInstance((LogCategory)JWTLogCategories.KEYS, UrlLocation.class);
    private final URI location;

    public UrlLocation(URI location) {
        this.location = location;
    }

    @Override
    public byte[] get() {
        long start = System.nanoTime();
        try {
            LOG.debug(String.format("Opening connection to Key Location %s", this.location));
            URL locationURL = this.location.toURL();
            byte[] bytes = IO.readBytes((URL)locationURL);
            long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            String message = String.format("Key Location %s returned %s bytes in %s ms", this.location, bytes.length, elapsed);
            LOG.info(message);
            return bytes;
        }
        catch (IOException e) {
            long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            LOG.error(String.format("Key Location %s read failed in %s ms", this.location, elapsed), (Throwable)e);
            throw new ReadFailureException(e);
        }
    }

    public static class ReadFailureException
    extends RuntimeException {
        public ReadFailureException(Exception cause) {
            super(String.format("Read failed: %s: %s", cause.getClass().getSimpleName(), cause.getMessage()), cause);
        }
    }
}

