/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class Messages {
    private static Map<String, ResourceBundle> _rbBundles = new ConcurrentHashMap<String, ResourceBundle>();
    private static Map<String, Map<String, MessageFormat>> _rbFormats = new ConcurrentHashMap<String, Map<String, MessageFormat>>();
    private static Locale _globalLocale;
    private ResourceBundle messages;
    private Map<String, MessageFormat> formats;
    private final Locale locale;
    private final String resourceName;

    public Messages(Class clazz) {
        this(Messages.packageName(clazz));
    }

    private static String packageName(Class clazz) {
        String name = clazz.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messages(String resourceName) {
        this.resourceName = resourceName + ".Messages";
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            this.locale = _globalLocale;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void init() {
        if (this.formats != null && this.messages != null) {
            return;
        }
        ResourceBundle rb = _rbBundles.get(this.resourceName);
        if (rb == null) {
            try {
                this.messages = this.locale == null ? ResourceBundle.getBundle(this.resourceName) : ResourceBundle.getBundle(this.resourceName, this.locale);
            }
            catch (Exception except) {
                this.messages = new EmptyResourceBundle();
            }
            this.formats = new ConcurrentHashMap<String, MessageFormat>();
            _rbBundles.put(this.resourceName, this.messages);
            _rbFormats.put(this.resourceName, this.formats);
        } else {
            this.messages = rb;
            this.formats = _rbFormats.get(this.resourceName);
        }
    }

    public String format(String message) {
        return this.message(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String format(String message, Object ... args) {
        this.init();
        if (this.locale != _globalLocale) {
            Class<Messages> clazz = Messages.class;
            // MONITORENTER : org.apache.openejb.util.Messages.class
            this.init();
            // MONITOREXIT : clazz
        }
        try {
            String msg;
            MessageFormat mf = this.formats.get(message);
            if (mf != null) return mf.format(args);
            try {
                msg = this.messages.getString(message);
            }
            catch (MissingResourceException except) {
                Object object;
                if (args != null) {
                    object = " " + Arrays.toString(args);
                    return message + (String)object;
                }
                object = "";
                return message + (String)object;
            }
            mf = new MessageFormat(msg);
            this.formats.put(message, mf);
            return mf.format(args);
        }
        catch (Exception except) {
            return "An internal error occured while processing message " + message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String message(String message) {
        this.init();
        if (this.locale != _globalLocale) {
            Class<Messages> clazz = Messages.class;
            // MONITORENTER : org.apache.openejb.util.Messages.class
            this.init();
            // MONITOREXIT : clazz
        }
        try {
            return this.messages.getString(message);
        }
        catch (MissingResourceException except) {
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) {
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            _globalLocale = locale;
            _rbBundles = new Hashtable<String, ResourceBundle>();
            _rbFormats = new Hashtable<String, Map<String, MessageFormat>>();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        Messages.setLocale(Locale.getDefault());
    }

    private static final class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration {
        private EmptyResourceBundle() {
        }

        public Enumeration getKeys() {
            return this;
        }

        @Override
        protected Object handleGetObject(String name) {
            return "[Missing message " + name + "]";
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

