/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;

public class CompactPathRule
extends Rule
implements Rule.ApplyURI {
    public CompactPathRule() {
        this._handling = false;
        this._terminating = false;
    }

    @Override
    public void applyURI(Request request, String oldURI, String newURI) {
        String uri = request.getHttpURI().getPathQuery();
        if (uri.startsWith("/")) {
            uri = URIUtil.compactPath((String)uri);
        }
        request.setHttpURI((HttpURI)HttpURI.build((HttpURI)request.getHttpURI(), (String)uri));
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (target.startsWith("/")) {
            return URIUtil.compactPath((String)target);
        }
        return target;
    }
}

