/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageProducer;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAQueueSender
extends ActiveMQRAMessageProducer
implements QueueSender {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ActiveMQRAQueueSender(QueueSender producer, ActiveMQRASession session) {
        super((MessageProducer)producer, session);
        if (logger.isTraceEnabled()) {
            logger.trace("constructor({}, {})", (Object)producer, (Object)session);
        }
    }

    public Queue getQueue() throws JMSException {
        logger.trace("getQueue()");
        return ((QueueSender)this.producer).getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Queue destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} destination={} message={} deliveryMode={} priority={} ttl={}", new Object[]{this, destination, message, deliveryMode, priority, timeToLive});
            }
            this.checkState();
            this.producer.send((Destination)destination, message, deliveryMode, priority, timeToLive);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Queue destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} destination={} message={}", new Object[]{this, destination, message});
            }
            this.checkState();
            this.producer.send((Destination)destination, message);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }
}

