/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.perf.test.BasicRecord;
import org.apache.avro.perf.test.BasicState;
import org.apache.avro.util.Utf8;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class RecordWithDefaultTest {
    private static final String RECORD_SCHEMA = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }";
    private static final String RECORD_SCHEMA_WITH_DEFAULT = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" },\n{ \"name\": \"f7\", \"type\": \"string\", \"default\": \"undefined\" },\n{ \"name\": \"f8\", \"type\": \"string\",\"default\": \"undefined\" }\n] }";

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        ResolvingDecoder r = (ResolvingDecoder)d;
        Utf8 utf = new Utf8();
        Schema.Field[] ff = r.readFieldOrder();
        for (int i = 0; i < state.getBatchSize(); ++i) {
            block6: for (int j = 0; j < ff.length; ++j) {
                Schema.Field f = ff[j];
                switch (f.pos()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        r.readDouble();
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        r.readInt();
                        continue block6;
                    }
                    case 6: 
                    case 7: {
                        r.readString(utf);
                    }
                }
            }
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private final Schema writerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }");
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" },\n{ \"name\": \"f7\", \"type\": \"string\", \"default\": \"undefined\" },\n{ \"name\": \"f8\", \"type\": \"string\",\"default\": \"undefined\" }\n] }");
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            for (int i = 0; i < this.getBatchSize(); ++i) {
                BasicRecord r = new BasicRecord(super.getRandom());
                encoder.writeDouble(r.f1);
                encoder.writeDouble(r.f2);
                encoder.writeDouble(r.f3);
                encoder.writeInt(r.f4);
                encoder.writeInt(r.f5);
                encoder.writeInt(r.f6);
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().resolvingDecoder(this.writerSchema, this.readerSchema, super.newDecoder(this.testData));
        }
    }
}

