/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Random;
import org.apache.commons.validator.routines.ISSNValidator;
import org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.commons.validator.routines.checkdigit.EAN13CheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ISSNValidatorTest {
    private static final ISSNValidator VALIDATOR = ISSNValidator.getInstance();
    private static final String[] VALID_FORMAT = new String[]{"ISSN 0317-8471", "1050-124X", "ISSN 1562-6865", "1063-7710", "1748-7188", "ISSN 0264-2875", "1750-0095", "1188-1534", "1911-1479", "ISSN 1911-1460", "0001-6772", "1365-201X", "0264-3596", "1144-875X"};
    private static final String[] INVALID_FORMAT = new String[]{"", "   ", "ISBN 0317-8471", "'1050-124X", "ISSN1562-6865", "10637710", "1748-7188'", "ISSN  0264-2875", "1750 0095", "1188_1534", "1911-1478"};

    ISSNValidatorTest() {
    }

    @Test
    void testConversionErrors() {
        String input1 = "9780072129519";
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.extractFromEAN13("9780072129519"), (String)"Expected IllegalArgumentException for '9780072129519'");
        String input2 = "9791090636071";
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.extractFromEAN13("9791090636071"), (String)"Expected IllegalArgumentException for '9791090636071'");
        String input3 = "03178471";
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.extractFromEAN13("03178471"), (String)"Expected IllegalArgumentException for '03178471'");
    }

    @Test
    void testInvalid() {
        for (String f : INVALID_FORMAT) {
            Assertions.assertFalse((boolean)VALIDATOR.isValid(f), (String)f);
        }
    }

    @Test
    void testIsValidExtract() {
        Assertions.assertEquals((Object)"12345679", (Object)VALIDATOR.extractFromEAN13("9771234567003"));
        Assertions.assertEquals((Object)"00014664", (Object)VALIDATOR.extractFromEAN13("9770001466006"));
        Assertions.assertEquals((Object)"03178471", (Object)VALIDATOR.extractFromEAN13("9770317847001"));
        Assertions.assertEquals((Object)"1144875X", (Object)VALIDATOR.extractFromEAN13("9771144875007"));
    }

    @Test
    void testIsValidISSN() {
        for (String f : VALID_FORMAT) {
            Assertions.assertTrue((boolean)VALIDATOR.isValid(f), (String)f);
        }
    }

    @Test
    void testIsValidISSNConvert() {
        CheckDigit ean13cd = EAN13CheckDigit.EAN13_CHECK_DIGIT;
        Random r = new Random();
        for (String f : VALID_FORMAT) {
            String suffix = String.format("%02d", r.nextInt(100));
            String ean13 = VALIDATOR.convertToEAN13(f, suffix);
            Assertions.assertTrue((boolean)ean13cd.isValid(ean13), (String)ean13);
        }
        Assertions.assertEquals((Object)VALIDATOR.convertToEAN13("1144-875X", "00"), (Object)"9771144875007");
        Assertions.assertEquals((Object)VALIDATOR.convertToEAN13("0264-3596", "00"), (Object)"9770264359008");
        Assertions.assertEquals((Object)VALIDATOR.convertToEAN13("1234-5679", "00"), (Object)"9771234567003");
    }

    @Test
    void testIsValidISSNConvertNull() {
        Assertions.assertNull((Object)VALIDATOR.convertToEAN13(null, "00"));
    }

    @Test
    void testIsValidISSNConvertSuffix() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.convertToEAN13(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.convertToEAN13(null, ""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.convertToEAN13(null, "0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.convertToEAN13(null, "A"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.convertToEAN13(null, "AA"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> VALIDATOR.convertToEAN13(null, "999"));
    }

    @Test
    void testNull() {
        Assertions.assertFalse((boolean)VALIDATOR.isValid(null), (String)"isValid");
    }

    @Test
    void testValidCheckDigitEan13() {
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567001"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567002"));
        Assertions.assertNotNull((Object)VALIDATOR.extractFromEAN13("9771234567003"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567004"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567005"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567006"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567007"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567008"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567009"));
        Assertions.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567000"));
    }
}

