/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.calendar;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import java.io.Serializable;
import org.apache.daffodil.lib.calendar.DFDLCalendar;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class DFDLCalendarConversion$
implements Serializable {
    public static final DFDLCalendarConversion$ MODULE$ = new DFDLCalendarConversion$();

    private DFDLCalendarConversion$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DFDLCalendarConversion$.class);
    }

    private String pad2(int i) {
        String istr = BoxesRunTime.boxToInteger((int)i).toString();
        if (i >= 10) {
            return istr;
        }
        return "0" + istr;
    }

    private String pad3(int i) {
        String istr = BoxesRunTime.boxToInteger((int)i).toString();
        if (i >= 100) {
            return istr;
        }
        if (i >= 10) {
            return "0" + istr;
        }
        return "00" + istr;
    }

    private String pad4(int i) {
        String istr = BoxesRunTime.boxToInteger((int)i).toString();
        if (i >= 1000) {
            return istr;
        }
        if (i >= 100) {
            return "0" + istr;
        }
        if (i >= 10) {
            return "00" + istr;
        }
        return "000" + istr;
    }

    public String datePartToXMLString(DFDLCalendar dfdlcal) {
        Calendar calendar = dfdlcal.calendar();
        int y = calendar.get(19);
        int m = calendar.get(2) + 1;
        int d = calendar.get(5);
        String ysign = y >= 0 ? "" : "-";
        return ysign + this.pad4(Math.abs(y)) + "-" + this.pad2(m) + "-" + this.pad2(d);
    }

    public String datePartFromXMLString(String string, Calendar calendar) {
        int endYear;
        if (string.length() == 0) {
            throw this.invalidValue$1(string);
        }
        int n = endYear = string.charAt(0) == '-' ? string.indexOf(45, 1) : string.indexOf(45);
        if (endYear == -1) {
            throw this.invalidValue$1(string);
        }
        if (string.length() < endYear + 6) {
            throw this.invalidValue$1(string);
        }
        if (string.charAt(endYear + 3) != '-') {
            throw this.invalidValue$1(string);
        }
        String y = string.substring(0, endYear);
        String m = string.substring(endYear + 1, endYear + 3);
        String d = string.substring(endYear + 4, endYear + 6);
        try {
            calendar.set(19, Integer.parseInt(y));
            calendar.set(2, Integer.parseInt(m) - 1);
            calendar.set(5, Integer.parseInt(d));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue$1(string);
        }
        return string.substring(endYear + 6);
    }

    public String timePartToXMLString(DFDLCalendar dfdlcal) {
        Calendar calendar = dfdlcal.calendar();
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        int u = calendar.get(14);
        return this.pad2(h) + ":" + this.pad2(m) + ":" + this.pad2(s) + (String)(u != 0 ? "." + this.pad3(u) + "000" : "");
    }

    public String timePartFromXMLString(String string, Calendar calendar) {
        int tzStart;
        if (string.length() < 8) {
            throw this.invalidValue$2(string);
        }
        if (string.charAt(2) != ':') {
            throw this.invalidValue$2(string);
        }
        if (string.charAt(5) != ':') {
            throw this.invalidValue$2(string);
        }
        String h = string.substring(0, 2);
        String m = string.substring(3, 5);
        String s = string.substring(6, 8);
        Tuple2 tuple2 = string.length() > 8 ? (string.charAt(8) != '.' ? Tuple2$.MODULE$.apply((Object)"0", (Object)BoxesRunTime.boxToInteger((int)8)) : ((tzStart = StringOps$.MODULE$.indexWhere$extension(Predef$.MODULE$.augmentString(string), (Function1 & Serializable)c -> DFDLCalendarConversion$.$anonfun$1(BoxesRunTime.unboxToChar((Object)c)), 9)) == -1 ? Tuple2$.MODULE$.apply((Object)string.substring(9), (Object)BoxesRunTime.boxToInteger((int)string.length())) : Tuple2$.MODULE$.apply((Object)string.substring(9, tzStart), (Object)BoxesRunTime.boxToInteger((int)tzStart)))) : Tuple2$.MODULE$.apply((Object)"0", (Object)BoxesRunTime.boxToInteger((int)8));
        String ms = (String)tuple2._1();
        int endTime = BoxesRunTime.unboxToInt((Object)tuple2._2());
        try {
            calendar.set(11, Integer.parseInt(h));
            calendar.set(12, Integer.parseInt(m));
            calendar.set(13, Integer.parseInt(s));
            int msDigits = Math.min(ms.length(), 3);
            int msUnscaled = Integer.parseInt(ms.substring(0, msDigits));
            int msScaled = msDigits == 1 ? msUnscaled * 100 : (msDigits == 2 ? msUnscaled * 10 : msUnscaled);
            calendar.set(14, msScaled);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue$2(string);
        }
        return string.substring(endTime);
    }

    public String timeZonePartToXMLString(DFDLCalendar dfdlcal) {
        if (!dfdlcal.hasTimeZone()) {
            return "";
        }
        TimeZone tz = dfdlcal.calendar().getTimeZone();
        int offsetInMils = tz.getRawOffset();
        int offsetInMins = Math.abs(offsetInMils / 60000);
        int h = offsetInMins / 60;
        int m = offsetInMins % 60;
        String s = offsetInMils >= 0 ? "+" : "-";
        return s + this.pad2(h) + ":" + this.pad2(m);
    }

    public String timeZonePartFromXMLString(String string, Calendar calendar) {
        Tuple2 tuple2;
        String string2 = string;
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return string;
        }
        char firstChar = string.charAt(0);
        if (firstChar == 'Z') {
            tuple2 = Tuple2$.MODULE$.apply((Object)TimeZone.GMT_ZONE, (Object)BoxesRunTime.boxToInteger((int)1));
        } else {
            int n;
            String string4;
            int n2;
            if (firstChar == '+') {
                n2 = 1;
            } else if (firstChar == '-') {
                n2 = -1;
            } else {
                throw this.invalidValue$3(string);
            }
            int sign = n2;
            if (string.length() < 6) {
                throw this.invalidValue$3(string);
            }
            if (string.charAt(3) != ':') {
                throw this.invalidValue$3(string);
            }
            String h = string.substring(1, 3);
            String m = string.substring(4, 6);
            if (string.length() > 6) {
                if (string.charAt(6) != ':') {
                    throw this.invalidValue$3(string);
                }
                string4 = string.substring(7, 9);
            } else {
                string4 = "00";
            }
            String s = string4;
            try {
                int hi = Integer.parseInt(h);
                int mi = Integer.parseInt(m);
                int si = Integer.parseInt(s);
                if (hi < 0 || hi >= 24) {
                    throw this.invalidValue$3(string);
                }
                if (mi < 0 || mi >= 60) {
                    throw this.invalidValue$3(string);
                }
                if (si < 0 || si >= 60) {
                    throw this.invalidValue$3(string);
                }
                n = sign * (hi * 60 * 60 + mi * 60 + si) * 1000;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue$3(string);
            }
            int offsetInMillis = n;
            TimeZone tz = offsetInMillis == 0 ? TimeZone.GMT_ZONE : new SimpleTimeZone(offsetInMillis, string);
            int consumed = string.length() > 6 ? 9 : 6;
            tuple2 = Tuple2$.MODULE$.apply((Object)tz, (Object)BoxesRunTime.boxToInteger((int)consumed));
        }
        Tuple2 tuple22 = tuple2;
        TimeZone timezone = (TimeZone)tuple22._1();
        int endTimeZone = BoxesRunTime.unboxToInt((Object)tuple22._2());
        calendar.setTimeZone(timezone);
        return string.substring(endTimeZone);
    }

    private final Nothing$ invalidValue$1(String string$1) {
        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid date string: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{string$1})));
    }

    private final Nothing$ invalidValue$2(String string$2) {
        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid time string: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{string$2})));
    }

    private static final /* synthetic */ boolean $anonfun$1(char c) {
        return c == '-' || c == '+' || c == 'Z';
    }

    private final Nothing$ invalidValue$3(String string$3) {
        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid time zone string: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{string$3})));
    }
}

