/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.layers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.layers.ChecksumLayerBase;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class ChecksumEncoderOutputStream
extends OutputStream {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ChecksumEncoderOutputStream.class.getDeclaredField("baos$lzy1"));
    private final ChecksumLayerBase layer;
    private final OutputStream jos;
    private volatile Object baos$lzy1;
    private long count;
    private boolean isOpen;

    public ChecksumEncoderOutputStream(ChecksumLayerBase layer, OutputStream jos) {
        this.layer = layer;
        this.jos = jos;
        this.count = 0L;
        this.isOpen = true;
    }

    private ByteArrayOutputStream baos() {
        Object object = this.baos$lzy1;
        if (object instanceof ByteArrayOutputStream) {
            return (ByteArrayOutputStream)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ByteArrayOutputStream)this.baos$lzyINIT1();
    }

    private Object baos$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.baos$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream(this.layer.getLength());
                        object2 = byteArrayOutputStream == null ? LazyVals.NullValue$.MODULE$ : byteArrayOutputStream;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.baos$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return byteArrayOutputStream;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void write(int b) {
        this.baos().write(b);
        ++this.count;
        if (this.count > (long)this.layer.getLength()) {
            this.layer.processingError(new IndexOutOfBoundsException("Written data amount exceeded fixed layer length of " + this.layer.getLength() + "."));
            return;
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            byte[] ba = this.baos().toByteArray();
            int baLen = ba.length;
            if (baLen > this.layer.getLength()) {
                throw Assert$.MODULE$.abort("Invariant broken: baLen.<=(ChecksumEncoderOutputStream.this.layer.getLength)");
            }
            ByteBuffer buf = ByteBuffer.wrap(ba);
            this.layer.setChecksum(this.layer.compute(true, buf));
            this.jos.write(ba);
            this.jos.flush();
            return;
        }
    }
}

