/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.iapi.UnqualifiedPathStepPolicy;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.OKOrError$;
import org.apache.daffodil.lib.util.ThreadSafePool;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$HexBinary$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$String$;
import org.apache.daffodil.runtime1.dsom.Facet;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.NonTermRuntimeData;
import org.apache.daffodil.runtime1.processors.VariableMap;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.xml.NamespaceBinding;

public final class SimpleTypeRuntimeData
extends NonTermRuntimeData {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SimpleTypeRuntimeData.class.getDeclaredField("matcherPool$lzy1"));
    private final NodeInfo.PrimType primType;
    private final boolean noFacetChecks;
    private final Seq patternValues;
    private final Option enumerationValues;
    private final Option length;
    private final Option minLength;
    private final Option maxLength;
    private final Option minInclusive;
    private final Option maxInclusive;
    private final Option minExclusive;
    private final Option maxExclusive;
    private final Option totalDigits;
    private final Option fractionDigits;
    private final Seq unionMemberTypes;
    private volatile Object matcherPool$lzy1;

    public SimpleTypeRuntimeData(VariableMap variableMapArg, SchemaFileLocation schemaFileLocationArg, String diagnosticDebugNameArg, String pathArg, NamespaceBinding namespacesArg, NS noPrefixNamespaceArg, NodeInfo.PrimType primType, boolean noFacetChecks, Seq<Tuple2<Facet.Type, Regex>> patternValues, Option<String> enumerationValues, Option<BigDecimal> length, Option<BigDecimal> minLength, Option<BigDecimal> maxLength, Option<BigDecimal> minInclusive, Option<BigDecimal> maxInclusive, Option<BigDecimal> minExclusive, Option<BigDecimal> maxExclusive, Option<BigDecimal> totalDigits, Option<BigDecimal> fractionDigits, Seq<SimpleTypeRuntimeData> unionMemberTypes, UnqualifiedPathStepPolicy unqualifiedPathStepPolicyArg) {
        this.primType = primType;
        this.noFacetChecks = noFacetChecks;
        this.patternValues = patternValues;
        this.enumerationValues = enumerationValues;
        this.length = length;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.minExclusive = minExclusive;
        this.maxExclusive = maxExclusive;
        this.totalDigits = totalDigits;
        this.fractionDigits = fractionDigits;
        this.unionMemberTypes = unionMemberTypes;
        super(variableMapArg, schemaFileLocationArg, diagnosticDebugNameArg, pathArg, namespacesArg, noPrefixNamespaceArg, unqualifiedPathStepPolicyArg);
    }

    public NodeInfo.PrimType primType() {
        return this.primType;
    }

    public boolean noFacetChecks() {
        return this.noFacetChecks;
    }

    public Seq<Tuple2<Facet.Type, Regex>> patternValues() {
        return this.patternValues;
    }

    public Option<String> enumerationValues() {
        return this.enumerationValues;
    }

    public Option<BigDecimal> length() {
        return this.length;
    }

    public Option<BigDecimal> minLength() {
        return this.minLength;
    }

    public Option<BigDecimal> maxLength() {
        return this.maxLength;
    }

    public Option<BigDecimal> minInclusive() {
        return this.minInclusive;
    }

    public Option<BigDecimal> maxInclusive() {
        return this.maxInclusive;
    }

    public Option<BigDecimal> minExclusive() {
        return this.minExclusive;
    }

    public Option<BigDecimal> maxExclusive() {
        return this.maxExclusive;
    }

    public Option<BigDecimal> totalDigits() {
        return this.totalDigits;
    }

    public Option<BigDecimal> fractionDigits() {
        return this.fractionDigits;
    }

    public Seq<SimpleTypeRuntimeData> unionMemberTypes() {
        return this.unionMemberTypes;
    }

    private ThreadSafePool<Tuple2<Seq<Matcher>, Option<Matcher>>> matcherPool() {
        Object object = this.matcherPool$lzy1;
        if (object instanceof ThreadSafePool) {
            return (ThreadSafePool)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ThreadSafePool)this.matcherPool$lzyINIT1();
    }

    private Object matcherPool$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.matcherPool$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ThreadSafePool<Tuple2<Seq<Matcher>, Option<Matcher>>> threadSafePool = null;
                    try {
                        threadSafePool = new ThreadSafePool<Tuple2<Seq<Matcher>, Option<Matcher>>>(this){
                            private final /* synthetic */ SimpleTypeRuntimeData $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public final Tuple2 allocate() {
                                Seq patternMatchers = (Seq)this.$outer.patternValues().map(SimpleTypeRuntimeData::org$apache$daffodil$runtime1$processors$SimpleTypeRuntimeData$$anon$1$$_$_$$anonfun$1);
                                Option optEnumMatcher = this.$outer.enumerationValues().map(SimpleTypeRuntimeData::org$apache$daffodil$runtime1$processors$SimpleTypeRuntimeData$$anon$1$$_$_$$anonfun$2);
                                return Tuple2$.MODULE$.apply((Object)patternMatchers, (Object)optEnumMatcher);
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$daffodil$runtime1$processors$SimpleTypeRuntimeData$$anon$1$$_$_$$anonfun$1(scala.Tuple2 ), org$apache$daffodil$runtime1$processors$SimpleTypeRuntimeData$$anon$1$$_$_$$anonfun$2(java.lang.String )}, serializedLambda);
                            }
                        };
                        object2 = threadSafePool == null ? LazyVals.NullValue$.MODULE$ : threadSafePool;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.matcherPool$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return threadSafePool;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String executeCheck(DISimple currentElement) {
        String facetResult;
        if (currentElement.isNilled()) {
            return OKOrError$.MODULE$.OK();
        }
        String string = facetResult = this.noFacetChecks() ? OKOrError$.MODULE$.OK() : this.executeFacetCheck(currentElement);
        if (OKOrError$.MODULE$.isError$extension(facetResult)) {
            return facetResult;
        }
        Seq<SimpleTypeRuntimeData> umts = this.unionMemberTypes();
        if (umts.length() == 0) {
            return OKOrError$.MODULE$.OK();
        }
        Option optUnionMemberRuntimeData = umts.find((Function1 & Serializable)mt -> OKOrError$.MODULE$.isOK$extension(mt.executeCheck(currentElement)));
        if (optUnionMemberRuntimeData.isDefined()) {
            Object object = currentElement.unionMemberRuntimeData();
            if (Maybe$.MODULE$.isEmpty$extension(object)) {
                currentElement.setUnionMemberRuntimeData((SimpleTypeRuntimeData)optUnionMemberRuntimeData.get());
            }
            return OKOrError$.MODULE$.OK();
        }
        return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Value '%s' is not one of the union members: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{currentElement.dataValueAsString(), ((IterableOnceOps)umts.map((Function1 & Serializable)umt -> umt.diagnosticDebugName())).mkString(", ")})));
    }

    public String executeFacetCheck(DISimple currentElement) {
        long fractionDigits;
        long totalDigits;
        BigDecimal maxExclusive;
        BigDecimal minExclusive;
        BigDecimal maxInclusive;
        BigDecimal minInclusive;
        BigDecimal maxLength;
        BigDecimal minLength;
        BigDecimal length;
        SimpleTypeRuntimeData e;
        block18: {
            if (this.noFacetChecks()) {
                throw Assert$.MODULE$.usageError("SimpleTypeRuntimeData.this.noFacetChecks.unary_!");
            }
            if (currentElement.isNilled()) {
                throw Assert$.MODULE$.abort("Invariant broken: currentElement.isNilled.unary_!");
            }
            e = this;
            if (e.patternValues().nonEmpty() || e.enumerationValues().isDefined()) {
                String string;
                block17: {
                    ThreadSafePool<Tuple2<Seq<Matcher>, Option<Matcher>>> ThreadSafePool_this = this.matcherPool();
                    Tuple2<Seq<Matcher>, Option<Matcher>> polled = ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().poll();
                    Tuple2<Seq<Matcher>, Option<Matcher>> inst = polled == null ? ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$allocate() : polled;
                    try {
                        boolean check;
                        boolean check2;
                        Tuple2<Seq<Matcher>, Option<Matcher>> tuple2 = inst;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Seq patternMatchers = (Seq)tuple2._1();
                        Option optEnumMatcher = (Option)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)patternMatchers, (Object)optEnumMatcher);
                        Seq patternMatchers2 = (Seq)tuple22._1();
                        Option optEnumMatcher2 = (Option)tuple22._2();
                        if (e.patternValues().nonEmpty() && !(check2 = this.checkPatterns(currentElement, (Seq<Matcher>)patternMatchers2))) {
                            String patternStrings = ((IterableOnceOps)e.patternValues().map((Function1 & Serializable)x$1 -> {
                                Regex regex;
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null && (regex = (Regex)tuple2._2()) != null) {
                                    Regex r = regex;
                                    return XMLUtils$.MODULE$.escape(r.pattern().pattern(), XMLUtils$.MODULE$.escape$default$2());
                                }
                                throw new MatchError((Object)tuple2);
                            })).mkString(",");
                            string = OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet pattern(s): %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{patternStrings})));
                            break block17;
                        }
                        if (!e.enumerationValues().isDefined() || (check = this.checkEnumerations(currentElement, (Matcher)optEnumMatcher2.get()))) break block18;
                        string = OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet enumeration(s): %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.option2Iterable(e.enumerationValues()).mkString(",")})));
                    }
                    finally {
                        ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().offer(inst);
                    }
                }
                return string;
            }
        }
        if (e.length().isDefined() && !Predef$.MODULE$.Boolean2boolean(this.checkLength(currentElement, length = (BigDecimal)e.length().get(), e, this.primType()))) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet length (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{length})));
        }
        if (e.minLength().isDefined() && !Predef$.MODULE$.Boolean2boolean(this.checkMinLength(currentElement, minLength = (BigDecimal)e.minLength().get(), e, this.primType()))) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet minLength (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{minLength})));
        }
        if (e.maxLength().isDefined() && !Predef$.MODULE$.Boolean2boolean(this.checkMaxLength(currentElement, maxLength = (BigDecimal)e.maxLength().get(), e, this.primType()))) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet maxLength (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{maxLength})));
        }
        if (e.minInclusive().isDefined() && !this.checkMinInc(currentElement, minInclusive = (BigDecimal)e.minInclusive().get(), this.primType(), e)) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet minInclusive (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{minInclusive})));
        }
        if (e.maxInclusive().isDefined() && !this.checkMaxInc(currentElement, maxInclusive = (BigDecimal)e.maxInclusive().get(), this.primType(), e)) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet maxInclusive (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{maxInclusive})));
        }
        if (e.minExclusive().isDefined() && !this.checkMinExc(currentElement, minExclusive = (BigDecimal)e.minExclusive().get(), this.primType(), e)) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet minExclusive (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{minExclusive})));
        }
        if (e.maxExclusive().isDefined() && !this.checkMaxExc(currentElement, maxExclusive = (BigDecimal)e.maxExclusive().get(), this.primType(), e)) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet maxExclusive (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{maxExclusive})));
        }
        if (e.totalDigits().isDefined() && (totalDigits = ((BigDecimal)e.totalDigits().get()).longValue()) >= 0L && !this.checkTotalDigits(currentElement, totalDigits)) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet totalDigits (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalDigits)})));
        }
        if (e.fractionDigits().isDefined() && (fractionDigits = ((BigDecimal)e.fractionDigits().get()).longValue()) >= 0L && !this.checkFractionDigits(currentElement, fractionDigits)) {
            return OKOrError$.MODULE$.Error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("facet fractionDigits (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)fractionDigits)})));
        }
        return OKOrError$.MODULE$.OK();
    }

    private Boolean checkLength(DISimple diNode, BigDecimal lenValue, ThrowsSDE e, NodeInfo.PrimType primType) {
        long lenAsLong = lenValue.longValueExact();
        NodeInfo.PrimType primType2 = primType;
        if (NodeInfo$PrimType$String$.MODULE$.equals(primType2)) {
            boolean isDataLengthEqual;
            Object object = diNode.dataValue();
            String data = DataValue$.MODULE$.getString$extension(object);
            long dataLen = data.length();
            boolean bl = isDataLengthEqual = Predef$.MODULE$.long2Long(dataLen).compareTo(Predef$.MODULE$.long2Long(lenAsLong)) == 0;
            if (isDataLengthEqual) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (NodeInfo$PrimType$HexBinary$.MODULE$.equals(primType2)) {
            boolean isDataLengthEqual;
            Object object = diNode.dataValue();
            byte[] data = DataValue$.MODULE$.getByteArray$extension(object);
            long dataLen = data.length;
            boolean bl = isDataLengthEqual = Predef$.MODULE$.long2Long(dataLen).compareTo(Predef$.MODULE$.long2Long(lenAsLong)) == 0;
            if (isDataLengthEqual) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw e.SDE("Facet length is only valid for string and hexBinary.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private Boolean checkMinLength(DISimple diNode, BigDecimal minValue, ThrowsSDE e, NodeInfo.PrimType primType) {
        long minAsLong = minValue.longValueExact();
        NodeInfo.PrimType primType2 = primType;
        if (NodeInfo$PrimType$String$.MODULE$.equals(primType2)) {
            boolean isDataLengthLess;
            Object object = diNode.dataValue();
            String data = DataValue$.MODULE$.getString$extension(object);
            long dataLen = data.length();
            boolean bl = isDataLengthLess = Predef$.MODULE$.long2Long(dataLen).compareTo(Predef$.MODULE$.long2Long(minAsLong)) < 0;
            if (isDataLengthLess) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (NodeInfo$PrimType$HexBinary$.MODULE$.equals(primType2)) {
            boolean isDataLengthEqual;
            Object object = diNode.dataValue();
            byte[] data = DataValue$.MODULE$.getByteArray$extension(object);
            long dataLen = data.length;
            boolean bl = isDataLengthEqual = Predef$.MODULE$.long2Long(dataLen).compareTo(Predef$.MODULE$.long2Long(minAsLong)) == 0;
            if (isDataLengthEqual) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw e.SDE("Facet minLength is only valid for string and hexBinary.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private Boolean checkMaxLength(DISimple diNode, BigDecimal maxValue, ThrowsSDE e, NodeInfo.PrimType primType) {
        long maxAsLong = maxValue.longValueExact();
        NodeInfo.PrimType primType2 = primType;
        if (NodeInfo$PrimType$String$.MODULE$.equals(primType2)) {
            boolean isDataLengthGreater;
            Object object = diNode.dataValue();
            String data = DataValue$.MODULE$.getString$extension(object);
            long dataLen = data.length();
            boolean bl = isDataLengthGreater = Predef$.MODULE$.long2Long(dataLen).compareTo(Predef$.MODULE$.long2Long(maxAsLong)) > 0;
            if (isDataLengthGreater) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (NodeInfo$PrimType$HexBinary$.MODULE$.equals(primType2)) {
            boolean isDataLengthEqual;
            Object object = diNode.dataValue();
            byte[] data = DataValue$.MODULE$.getByteArray$extension(object);
            long dataLen = data.length;
            boolean bl = isDataLengthEqual = Predef$.MODULE$.long2Long(dataLen).compareTo(Predef$.MODULE$.long2Long(maxAsLong)) == 0;
            if (isDataLengthEqual) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw e.SDE("Facet maxLength is only valid for string and hexBinary.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private boolean checkMinInc(DISimple diNode, BigDecimal minValue, NodeInfo.PrimType primType, ThrowsSDE e) {
        Object object = diNode.dataValue();
        Object object2 = DataValue$.MODULE$.getAnyRef$extension(object);
        if (object2 instanceof Float) {
            Float f = (Float)object2;
            return f.compareTo(Predef$.MODULE$.float2Float(minValue.floatValue())) >= 0;
        }
        if (object2 instanceof Double) {
            Double d = (Double)object2;
            return d.compareTo(Predef$.MODULE$.double2Double(minValue.doubleValue())) >= 0;
        }
        return diNode.dataValueAsBigDecimal().compareTo(minValue) >= 0;
    }

    private boolean checkMinExc(DISimple diNode, BigDecimal minValue, NodeInfo.PrimType primType, ThrowsSDE e) {
        Object object = diNode.dataValue();
        Object object2 = DataValue$.MODULE$.getAnyRef$extension(object);
        if (object2 instanceof Float) {
            Float f = (Float)object2;
            return f.compareTo(Predef$.MODULE$.float2Float(minValue.floatValue())) > 0;
        }
        if (object2 instanceof Double) {
            Double d = (Double)object2;
            return d.compareTo(Predef$.MODULE$.double2Double(minValue.doubleValue())) > 0;
        }
        return diNode.dataValueAsBigDecimal().compareTo(minValue) > 0;
    }

    private boolean checkMaxInc(DISimple diNode, BigDecimal maxValue, NodeInfo.PrimType primType, ThrowsSDE e) {
        Object object = diNode.dataValue();
        Object object2 = DataValue$.MODULE$.getAnyRef$extension(object);
        if (object2 instanceof Float) {
            Float f = (Float)object2;
            return f.compareTo(Predef$.MODULE$.float2Float(maxValue.floatValue())) <= 0;
        }
        if (object2 instanceof Double) {
            Double d = (Double)object2;
            return d.compareTo(Predef$.MODULE$.double2Double(maxValue.doubleValue())) <= 0;
        }
        return diNode.dataValueAsBigDecimal().compareTo(maxValue) <= 0;
    }

    private boolean checkMaxExc(DISimple diNode, BigDecimal maxValue, NodeInfo.PrimType primType, ThrowsSDE e) {
        Object object = diNode.dataValue();
        Object object2 = DataValue$.MODULE$.getAnyRef$extension(object);
        if (object2 instanceof Float) {
            Float f = (Float)object2;
            return f.compareTo(Predef$.MODULE$.float2Float(maxValue.floatValue())) < 0;
        }
        if (object2 instanceof Double) {
            Double d = (Double)object2;
            return d.compareTo(Predef$.MODULE$.double2Double(maxValue.doubleValue())) < 0;
        }
        return diNode.dataValueAsBigDecimal().compareTo(maxValue) < 0;
    }

    private boolean checkTotalDigits(DISimple diNode, long digits) {
        BigDecimal bd = diNode.dataValueAsBigDecimal().stripTrailingZeros();
        int totalDigits = bd.scale() <= 0 ? bd.precision() - bd.scale() : Math.max(bd.precision(), bd.scale());
        return (long)totalDigits <= digits;
    }

    private boolean checkFractionDigits(DISimple diNode, long digits) {
        BigDecimal rounded;
        BigDecimal bdData = diNode.dataValueAsBigDecimal();
        boolean isDataSameAsRounded = bdData.compareTo(rounded = bdData.setScale(Predef$.MODULE$.long2Long(digits).intValue(), RoundingMode.HALF_DOWN)) == 0;
        return isDataSameAsRounded;
    }

    private boolean checkEnumerations(DISimple diNode, Matcher enumMatcher) {
        String data = diNode.dataValueAsString();
        enumMatcher.reset(data);
        return enumMatcher.matches();
    }

    private boolean checkPatterns(DISimple diNode, Seq<Matcher> matchers) {
        String data = diNode.dataValueAsString();
        boolean isSuccess = true;
        boolean done = false;
        int n = matchers.length();
        for (int i = 0; !done && i < n; ++i) {
            Matcher m = (Matcher)matchers.apply(i);
            m.reset(data);
            if (m.matches()) continue;
            isSuccess = false;
            done = true;
        }
        return isSuccess;
    }

    public static final /* synthetic */ Matcher org$apache$daffodil$runtime1$processors$SimpleTypeRuntimeData$$anon$1$$_$_$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Regex r = (Regex)tuple2._2();
            return r.pattern().matcher("");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Matcher org$apache$daffodil$runtime1$processors$SimpleTypeRuntimeData$$anon$1$$_$_$$anonfun$2(String en) {
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(en)).pattern().matcher("");
    }
}

