/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import scala.Function2;
import scala.Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public interface ByteChunkWriter {
    public static void writeBitsInChunks$(ByteChunkWriter $this, PState start, long nBits, Function2 writeChunk) {
        $this.writeBitsInChunks(start, nBits, (Function2<byte[], Object, BoxedUnit>)writeChunk);
    }

    default public void writeBitsInChunks(PState start, long nBits, Function2<byte[], Object, BoxedUnit> writeChunk) {
        InputSourceDataInputStream dis = start.dataInputStream();
        DataLocation startLoc = start.currentLocation();
        SchemaFileLocation startSfl = start.schemaFileLocation();
        long remainingBitsToGet = nBits;
        byte[] array = new byte[start.tunable().blobChunkSizeInBytes()];
        int blobChunkSizeInBits = start.tunable().blobChunkSizeInBytes() * 8;
        while (remainingBitsToGet > 0L) {
            long bitsToGet = Math.min(remainingBitsToGet, Int$.MODULE$.int2long(blobChunkSizeInBits));
            if (dis.isDefinedForLength(bitsToGet)) {
                start.dataInputStream().getByteArray((int)bitsToGet, start, array);
                long bytesToPut = (bitsToGet + 7L) / 8L;
                writeChunk.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)((int)bytesToPut)));
                remainingBitsToGet -= bitsToGet;
                continue;
            }
            ((Parser)((Object)this)).PENotEnoughBits(start, startSfl, startLoc, nBits, start.dataInputStream());
            remainingBitsToGet = 0L;
        }
    }
}

