/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.RangeBound;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import org.apache.daffodil.runtime1.processors.parsers.ChoiceDispatchFailed;
import org.apache.daffodil.runtime1.processors.parsers.ChoiceDispatchNoMatch;
import org.apache.daffodil.runtime1.processors.parsers.CombinatorParser;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class ChoiceDispatchCombinatorParserBase
extends CombinatorParser {
    private final TermRuntimeData rd;
    private final Map<String, Tuple2<Parser, Object>> dispatchBranchKeyMap;
    private final Vector<Tuple4<RangeBound, RangeBound, Parser, Object>> dispatchKeyRangeMap;

    public ChoiceDispatchCombinatorParserBase(TermRuntimeData rd, Map<String, Tuple2<Parser, Object>> dispatchBranchKeyMap, Vector<Tuple4<RangeBound, RangeBound, Parser, Object>> dispatchKeyRangeMap) {
        this.rd = rd;
        this.dispatchBranchKeyMap = dispatchBranchKeyMap;
        this.dispatchKeyRangeMap = dispatchKeyRangeMap;
        super(rd);
    }

    @Override
    public String nom() {
        return "ChoiceDispatch";
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    @Override
    public Vector<Processor> childProcessors() {
        return (Vector)CollectionConverters$.MODULE$.IteratorHasAsScala(this.dispatchBranchKeyMap.values().iterator()).asScala().map((Function1 & Serializable)_$1 -> (Parser)_$1._1()).toVector().$plus$plus((IterableOnce)this.dispatchKeyRangeMap.map((Function1 & Serializable)_$2 -> (Parser)_$2._3()));
    }

    public abstract Object computeDispatchKey(PState var1);

    @Override
    public void parse(PState pstate) {
        PState PStateUsingMacrosMixin_this = pstate;
        PState.Mark pou = PStateUsingMacrosMixin_this.createPointOfUncertainty("ChoiceDispatchCombinator", this.rd);
        try {
            Object maybeKey = this.computeDispatchKey(pstate);
            if (pstate.processorStatus() == Success$.MODULE$) {
                Some parserOpt2;
                Some some;
                String key = (String)Maybe$.MODULE$.get$extension(maybeKey);
                Tuple2<Parser, Object> parserOpt1 = this.dispatchBranchKeyMap.get(key);
                if (parserOpt1 != null) {
                    some = Some$.MODULE$.apply(parserOpt1);
                } else if (!this.dispatchKeyRangeMap.isEmpty()) {
                    try {
                        BigInteger keyAsBigInt = new BigInteger(key);
                        Option optAns1 = this.dispatchKeyRangeMap.find((Function1 & Serializable)x$1 -> {
                            Tuple4 tuple4 = x$1;
                            if (tuple4 != null) {
                                RangeBound min = (RangeBound)tuple4._1();
                                RangeBound max = (RangeBound)tuple4._2();
                                return min.testAsLower(DataValue$.MODULE$.toDataValue(keyAsBigInt)) && max.testAsUpper(DataValue$.MODULE$.toDataValue(keyAsBigInt));
                            }
                            throw new MatchError((Object)tuple4);
                        });
                        some = optAns1.map((Function1 & Serializable)x$1 -> {
                            Tuple4 tuple4 = x$1;
                            if (tuple4 != null) {
                                Parser parser = (Parser)tuple4._3();
                                boolean isRepresented = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
                                return Tuple2$.MODULE$.apply((Object)parser, (Object)BoxesRunTime.boxToBoolean((boolean)isRepresented));
                            }
                            throw new MatchError((Object)tuple4);
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        some = None$.MODULE$;
                    }
                } else {
                    some = None$.MODULE$;
                }
                Some parserOpt = parserOpt2 = some;
                if (parserOpt.isEmpty()) {
                    ChoiceDispatchNoMatch diag = new ChoiceDispatchNoMatch(this.context().schemaFileLocation(), pstate, key);
                    pstate.setFailed(diag);
                } else {
                    Logger LoggerImpl_this;
                    Tuple2 tuple2 = (Tuple2)parserOpt.get();
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Parser parser = (Parser)tuple2._1();
                    boolean isRepresented = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)parser, (Object)BoxesRunTime.boxToBoolean((boolean)isRepresented));
                    Parser parser2 = (Parser)tuple22._1();
                    boolean isRepresented2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
                    if (isRepresented2) {
                        pstate.resetToPointOfUncertainty(pou);
                    }
                    if ((LoggerImpl_this = Logger$.MODULE$.log()).underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Dispatching to choice alternative: {}", (Object)parser2);
                    }
                    parser2.parse1(pstate);
                    if (pstate.processorStatus() == Success$.MODULE$) {
                        Logger LoggerImpl_this2 = Logger$.MODULE$.log();
                        if (LoggerImpl_this2.underlying().isDebugEnabled()) {
                            LoggerImpl_this2.underlying().debug("Choice dispatch success: {}", (Object)parser2);
                        }
                    } else {
                        Logger LoggerImpl_this3 = Logger$.MODULE$.log();
                        if (LoggerImpl_this3.underlying().isDebugEnabled()) {
                            LoggerImpl_this3.underlying().debug("Choice dispatch failed: {}", (Object)parser2);
                        }
                        ChoiceDispatchFailed diag = new ChoiceDispatchFailed(this.context().schemaFileLocation(), pstate, pstate.diagnostics());
                        pstate.setFailed(diag);
                    }
                }
            }
        }
        finally {
            if (!PStateUsingMacrosMixin_this.isPointOfUncertaintyResolved(pou)) {
                PStateUsingMacrosMixin_this.discardPointOfUncertainty(pou);
            }
        }
    }
}

