/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.text.ParsePosition;
import org.apache.daffodil.lib.calendar.DFDLCalendar;
import org.apache.daffodil.lib.calendar.DFDLDate$;
import org.apache.daffodil.lib.calendar.DFDLDateTime$;
import org.apache.daffodil.lib.calendar.DFDLTime$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.ThreadSafePool;
import org.apache.daffodil.runtime1.dsom.TunableLimitExceededError;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.CalendarEv;
import org.apache.daffodil.runtime1.processors.DateTimeFormatterEv;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.parsers.ConvertTextCalendarParser$;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.TextPrimParser;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ConvertTextCalendarParser
implements ToBriefXMLImpl,
Processor,
PrimProcessor,
Parser,
TextPrimParser,
Product {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConvertTextCalendarParser.class.getDeclaredField("parserName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConvertTextCalendarParser.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private volatile Object parserName$lzy1;
    private final ElementRuntimeData context;
    private final String xsdType;
    private final String prettyType;
    private final String pattern;
    private final boolean hasTZ;
    private final CalendarEv calendarEv;
    private final DateTimeFormatterEv dateTimeFormatterEv;

    public static ConvertTextCalendarParser apply(ElementRuntimeData elementRuntimeData, String string, String string2, String string3, boolean bl, CalendarEv calendarEv, DateTimeFormatterEv dateTimeFormatterEv) {
        return ConvertTextCalendarParser$.MODULE$.apply(elementRuntimeData, string, string2, string3, bl, calendarEv, dateTimeFormatterEv);
    }

    public static ConvertTextCalendarParser fromProduct(Product product) {
        return ConvertTextCalendarParser$.MODULE$.fromProduct(product);
    }

    public static ConvertTextCalendarParser unapply(ConvertTextCalendarParser convertTextCalendarParser) {
        return ConvertTextCalendarParser$.MODULE$.unapply(convertTextCalendarParser);
    }

    public ConvertTextCalendarParser(ElementRuntimeData context, String xsdType, String prettyType, String pattern, boolean hasTZ, CalendarEv calendarEv, DateTimeFormatterEv dateTimeFormatterEv) {
        this.context = context;
        this.xsdType = xsdType;
        this.prettyType = prettyType;
        this.pattern = pattern;
        this.hasTZ = hasTZ;
        this.calendarEv = calendarEv;
        this.dateTimeFormatterEv = dateTimeFormatterEv;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        Parser.$init$(this);
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public String parserName() {
        Object object = this.parserName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.parserName$lzyINIT1();
    }

    private Object parserName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parserName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Parser.parserName$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parserName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.context()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.xsdType()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.prettyType()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pattern()));
        n = Statics.mix((int)n, (int)(this.hasTZ() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.calendarEv()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dateTimeFormatterEv()));
        return Statics.finalizeHash((int)n, (int)7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConvertTextCalendarParser)) return false;
        ConvertTextCalendarParser convertTextCalendarParser = (ConvertTextCalendarParser)object;
        if (this.hasTZ() != convertTextCalendarParser.hasTZ()) return false;
        ElementRuntimeData elementRuntimeData = this.context();
        ElementRuntimeData elementRuntimeData2 = convertTextCalendarParser.context();
        if (elementRuntimeData == null) {
            if (elementRuntimeData2 != null) {
                return false;
            }
        } else if (!((Object)elementRuntimeData).equals(elementRuntimeData2)) return false;
        String string = this.xsdType();
        String string2 = convertTextCalendarParser.xsdType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.prettyType();
        String string4 = convertTextCalendarParser.prettyType();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.pattern();
        String string6 = convertTextCalendarParser.pattern();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        CalendarEv calendarEv = this.calendarEv();
        CalendarEv calendarEv2 = convertTextCalendarParser.calendarEv();
        if (calendarEv == null) {
            if (calendarEv2 != null) {
                return false;
            }
        } else if (!calendarEv.equals(calendarEv2)) return false;
        DateTimeFormatterEv dateTimeFormatterEv = this.dateTimeFormatterEv();
        DateTimeFormatterEv dateTimeFormatterEv2 = convertTextCalendarParser.dateTimeFormatterEv();
        if (dateTimeFormatterEv == null) {
            if (dateTimeFormatterEv2 != null) {
                return false;
            }
        } else if (!dateTimeFormatterEv.equals(dateTimeFormatterEv2)) return false;
        if (!convertTextCalendarParser.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof ConvertTextCalendarParser;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "ConvertTextCalendarParser";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "context";
            }
            case 1: {
                return "xsdType";
            }
            case 2: {
                return "prettyType";
            }
            case 3: {
                return "pattern";
            }
            case 4: {
                return "hasTZ";
            }
            case 5: {
                return "calendarEv";
            }
            case 6: {
                return "dateTimeFormatterEv";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    public String xsdType() {
        return this.xsdType;
    }

    public String prettyType() {
        return this.prettyType;
    }

    public String pattern() {
        return this.pattern;
    }

    public boolean hasTZ() {
        return this.hasTZ;
    }

    public CalendarEv calendarEv() {
        return this.calendarEv;
    }

    public DateTimeFormatterEv dateTimeFormatterEv() {
        return this.dateTimeFormatterEv;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Evaluatable[]{this.calendarEv(), this.dateTimeFormatterEv()}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parse(PState start) {
        DFDLCalendar dFDLCalendar;
        DISimple node;
        block14: {
            ThreadSafePool dateTimeFormatterPool;
            node = start.simpleElement();
            String str = node.dataValueAsString();
            if (str == null) {
                throw Assert$.MODULE$.abort("Invariant broken: str.!=(null)");
            }
            ParsePosition pos = new ParsePosition(0);
            Calendar calendarOrig = (Calendar)this.calendarEv().evaluate(start);
            calendarOrig.clear();
            Calendar calendar = (Calendar)calendarOrig.clone();
            ThreadSafePool ThreadSafePool_this = dateTimeFormatterPool = (ThreadSafePool)this.dateTimeFormatterEv().evaluate(start);
            SimpleDateFormat polled = (SimpleDateFormat)ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().poll();
            SimpleDateFormat inst = polled == null ? (SimpleDateFormat)ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$allocate() : polled;
            try {
                inst.setCalendar(calendar);
                inst.parse(str, calendar, pos);
            }
            finally {
                ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().offer(inst);
            }
            if (pos.getIndex() == 0 || pos.getIndex() != str.length()) {
                this.PE(start, "Unable to parse xs:%s from text: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.xsdType(), str}));
                return;
            }
            try {
                calendar.getTime();
                if (calendar.get(1) > start.tunable().maxValidYear() || calendar.get(1) < start.tunable().minValidYear()) {
                    throw new TunableLimitExceededError(this.context().schemaFileLocation(), "Year value of %s is not within the limits of the tunables minValidYear (%s) and maxValidYear (%s)", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)calendar.get(1)), BoxesRunTime.boxToInteger((int)start.tunable().minValidYear()), BoxesRunTime.boxToInteger((int)start.tunable().maxValidYear())}));
                }
            }
            catch (IllegalArgumentException e) {
                this.PE(start, "Unable to parse xs:%s from text: %s. %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.xsdType(), str, e.getMessage()}));
                return;
            }
            String string = this.xsdType().toLowerCase();
            switch (string == null ? 0 : string.hashCode()) {
                case 3076014: {
                    if (!"date".equals(string)) break;
                    dFDLCalendar = DFDLDate$.MODULE$.apply(calendar, this.hasTZ());
                    break block14;
                }
                case 3560141: {
                    if (!"time".equals(string)) break;
                    dFDLCalendar = DFDLTime$.MODULE$.apply(calendar, this.hasTZ());
                    break block14;
                }
                case 1793702779: {
                    if (!"datetime".equals(string)) break;
                    dFDLCalendar = DFDLDateTime$.MODULE$.apply(calendar, this.hasTZ());
                    break block14;
                }
            }
            throw Assert$.MODULE$.impossibleCase();
        }
        DFDLCalendar infosetCalendar = dFDLCalendar;
        node.overwriteDataValue(DataValue$.MODULE$.toDataValue(infosetCalendar));
    }

    public ConvertTextCalendarParser copy(ElementRuntimeData context, String xsdType, String prettyType, String pattern, boolean hasTZ, CalendarEv calendarEv, DateTimeFormatterEv dateTimeFormatterEv) {
        return new ConvertTextCalendarParser(context, xsdType, prettyType, pattern, hasTZ, calendarEv, dateTimeFormatterEv);
    }

    public ElementRuntimeData copy$default$1() {
        return this.context();
    }

    public String copy$default$2() {
        return this.xsdType();
    }

    public String copy$default$3() {
        return this.prettyType();
    }

    public String copy$default$4() {
        return this.pattern();
    }

    public boolean copy$default$5() {
        return this.hasTZ();
    }

    public CalendarEv copy$default$6() {
        return this.calendarEv();
    }

    public DateTimeFormatterEv copy$default$7() {
        return this.dateTimeFormatterEv();
    }

    public ElementRuntimeData _1() {
        return this.context();
    }

    public String _2() {
        return this.xsdType();
    }

    public String _3() {
        return this.prettyType();
    }

    public String _4() {
        return this.pattern();
    }

    public boolean _5() {
        return this.hasTZ();
    }

    public CalendarEv _6() {
        return this.calendarEv();
    }

    public DateTimeFormatterEv _7() {
        return this.dateTimeFormatterEv();
    }
}

