/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Bits$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Bytes$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Characters$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.lib.util.OKOrError$;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.SimpleTypeRuntimeData;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import passera.unsigned.ULong$;
import scala.DummyImplicit$;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public interface CalculatedPrefixedLengthUnparserMixin {
    public LengthUnits lengthUnits();

    public long prefixedLengthAdjustmentInUnits();

    public static void assignPrefixLength$(CalculatedPrefixedLengthUnparserMixin $this, UState state, DIElement elem, DISimple plElem) {
        $this.assignPrefixLength(state, elem, plElem);
    }

    default public void assignPrefixLength(UState state, DIElement elem, DISimple plElem) {
        long l;
        LengthUnits lengthUnits = this.lengthUnits();
        if (LengthUnits$Bits$.MODULE$.equals(lengthUnits)) {
            l = elem.contentLength().lengthInBits();
        } else if (LengthUnits$Bytes$.MODULE$.equals(lengthUnits)) {
            l = elem.contentLength().lengthInBytes();
        } else if (LengthUnits$Characters$.MODULE$.equals(lengthUnits)) {
            int fixedWidth;
            long maybeFixedWidth = elem.erd().encInfo().getEncoderInfo(state).coder().bitsCharset().maybeFixedWidth();
            if (MaybeInt$.MODULE$.isDefined$extension(maybeFixedWidth)) {
                fixedWidth = MaybeInt$.MODULE$.get$extension(maybeFixedWidth);
                if (ULong$.MODULE$.$percent$extension(elem.contentLength().lengthInBits(), fixedWidth, DummyImplicit$.MODULE$.dummyImplicit()) != 0L) {
                    throw Assert$.MODULE$.abort("Invariant broken: elem.contentLength.lengthInBits.%(fixedWidth)(scala.DummyImplicit.dummyImplicit).==(0)");
                }
            } else {
                throw Assert$.MODULE$.invariantFailed("Not supported: prefixed length with variable-width or non-constant encoding.");
            }
            long lengthInChars = ULong$.MODULE$.$div$extension(elem.contentLength().lengthInBits(), fixedWidth, DummyImplicit$.MODULE$.dummyImplicit());
            l = ULong$.MODULE$.apply(lengthInChars);
        } else {
            throw new MatchError((Object)lengthUnits);
        }
        long lenInUnits = l;
        long adjustedLenInUnits = ULong$.MODULE$.$plus$extension(lenInUnits, this.prefixedLengthAdjustmentInUnits(), DummyImplicit$.MODULE$.dummyImplicit());
        plElem.setDataValue(DataValue$.MODULE$.toDataValue((Integer)((int)adjustedLenInUnits)));
        Option<SimpleTypeRuntimeData> optSTRD = plElem.erd().optSimpleTypeRuntimeData();
        if (optSTRD.isDefined()) {
            SimpleTypeRuntimeData strd = (SimpleTypeRuntimeData)optSTRD.get();
            String check = strd.executeCheck(plElem);
            if (OKOrError$.MODULE$.isError$extension(check)) {
                throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(state.schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "The prefix length value of " + elem.namedQName() + " (" + adjustedLenInUnits + ") failed check due to " + check, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            return;
        }
    }
}

