/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import com.typesafe.scalalogging.Logger;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeULong;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.processors.DelimiterStackUnparseNode;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.dfa.DFADelimiter;
import org.apache.daffodil.runtime1.processors.parsers.DelimiterTextType;
import org.apache.daffodil.runtime1.processors.parsers.DelimiterTextType$Initiator$;
import org.apache.daffodil.runtime1.processors.parsers.DelimiterTextType$Separator$;
import org.apache.daffodil.runtime1.processors.unparsers.TextPrimUnparser;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class DelimiterTextUnparser
implements ToBriefXMLImpl,
Processor,
Unparser,
PrimProcessor,
TextPrimUnparser {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DelimiterTextUnparser.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DelimiterTextUnparser.class.getDeclaredField("nom$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private final TermRuntimeData context;
    private final DelimiterTextType.Type delimiterType;
    private volatile Object nom$lzy1;

    public DelimiterTextUnparser(TermRuntimeData context, DelimiterTextType.Type delimiterType) {
        this.context = context;
        this.delimiterType = delimiterType;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public TermRuntimeData context() {
        return this.context;
    }

    private TermRuntimeData erd() {
        return this.context();
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    @Override
    public String nom() {
        Object object = this.nom$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.nom$lzyINIT1();
    }

    private Object nom$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.nom$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        DelimiterTextType.Type type = this.delimiterType;
                        DelimiterTextType$Initiator$ delimiterTextType$Initiator$ = DelimiterTextType$Initiator$.MODULE$;
                        if (!(type != null ? !type.equals(delimiterTextType$Initiator$) : delimiterTextType$Initiator$ != null)) {
                            v1 = "InitiatorUnparser";
                        } else {
                            DelimiterTextType.Type type2 = this.delimiterType;
                            DelimiterTextType$Separator$ delimiterTextType$Separator$ = DelimiterTextType$Separator$.MODULE$;
                            v1 = !(type2 != null ? !type2.equals(delimiterTextType$Separator$) : delimiterTextType$Separator$ != null) ? "SeparatorUnparser" : (string = "TerminatorUnparser");
                        }
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.nom$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String toBriefXML(int depthLimit) {
        if (depthLimit == 0) {
            return "...";
        }
        return "<" + this.nom() + " />";
    }

    @Override
    public int toBriefXML$default$1() {
        return -1;
    }

    @Override
    public void unparse(UState state) {
        DFADelimiter[] delimDFAs;
        Logger LoggerImpl_this = Logger$.MODULE$.log();
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Unparsing starting at bit position: {}", (Object)new MaybeULong(state.getDataOutputStream().maybeAbsBitPos0b()));
        }
        DelimiterStackUnparseNode localDelimNode = state.localDelimiters();
        DelimiterTextType.Type type = this.delimiterType;
        DelimiterTextType$Initiator$ delimiterTextType$Initiator$ = DelimiterTextType$Initiator$.MODULE$;
        if (!(type != null ? !type.equals(delimiterTextType$Initiator$) : delimiterTextType$Initiator$ != null)) {
            v1 = localDelimNode.initiator();
        } else {
            DelimiterTextType.Type type2 = this.delimiterType;
            DelimiterTextType$Separator$ delimiterTextType$Separator$ = DelimiterTextType$Separator$.MODULE$;
            v1 = !(type2 != null ? !type2.equals(delimiterTextType$Separator$) : delimiterTextType$Separator$ != null) ? localDelimNode.separator() : (delimDFAs = localDelimNode.terminator());
        }
        if (delimDFAs.length == 0) {
            throw Assert$.MODULE$.invariantFailed("Expected a delimiter of type " + this.delimiterType + " on the stack, but was not found.");
        }
        DFADelimiter delimDFA = delimDFAs[0];
        try {
            String valueString = delimDFA.unparseValue();
            DirectOrBufferedDataOutputStream outStream = state.getDataOutputStream();
            long nCharsWritten = outStream.putString(valueString, state);
            if (nCharsWritten != (long)valueString.length()) {
                throw this.UE(state, "%s - Too many bits in delimiter: IndexOutOfBounds. Insufficient space to write delimiter '%s'.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.nom(), Misc$.MODULE$.remapStringToVisibleGlyphs(valueString)}));
            }
        }
        catch (MalformedInputException m) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.erd().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "%s - MalformedInputException: \n%s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.nom(), m.getMessage()}));
        }
        catch (UnmappableCharacterException u) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.erd().schemaFileLocation()), Maybe$One$.MODULE$.apply(state.currentLocation()), "%s - UnmappableCharacterException: \n%s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.nom(), u.getMessage()}));
        }
    }
}

