/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.coder;

import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.coder.EXIBodyDecoderInOrder;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.event.EventType;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.util.List;

public class EXIBodyDecoderInOrderSC
extends EXIBodyDecoderInOrder {
    protected EXIBodyDecoderInOrderSC scDecoder;

    public EXIBodyDecoderInOrderSC(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        assert (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED"));
    }

    @Override
    public void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.scDecoder = null;
    }

    public void skipSCElement(long skip) throws IOException {
        assert (this.nextEventType == EventType.SELF_CONTAINED);
        this.channel.align();
        int i = 0;
        while ((long)i < skip) {
            this.channel.decode();
            ++i;
        }
        this.popElement();
    }

    @Override
    public EventType next() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.next();
        }
        EventType et = this.scDecoder.next();
        if (et == EventType.END_DOCUMENT) {
            this.scDecoder.decodeEndDocument();
            this.channel.align();
            this.scDecoder = null;
            this.popElement();
            et = super.next();
        }
        return et;
    }

    @Override
    public void decodeStartDocument() throws EXIException {
        if (this.scDecoder == null) {
            super.decodeStartDocument();
        } else {
            this.scDecoder.decodeStartDocument();
        }
    }

    @Override
    public void decodeEndDocument() throws EXIException, IOException {
        if (this.scDecoder != null) {
            throw new RuntimeException("[EXI] SC not closed properly?");
        }
        super.decodeEndDocument();
    }

    @Override
    public QNameContext decodeStartElement() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeStartElement();
        }
        return this.scDecoder.decodeStartElement();
    }

    @Override
    public void decodeStartSelfContainedFragment() throws EXIException, IOException {
        if (this.scDecoder == null) {
            EXIFactory scEXIFactory = this.exiFactory.clone();
            scEXIFactory.setFragment(true);
            this.scDecoder = (EXIBodyDecoderInOrderSC)scEXIFactory.createEXIBodyDecoder();
            this.scDecoder.channel = this.channel;
            this.scDecoder.setErrorHandler(this.errorHandler);
            this.scDecoder.initForEachRun();
            this.channel.align();
            this.scDecoder.decodeStartDocument();
            EventType et = this.next();
            switch (et) {
                case START_ELEMENT: 
                case START_ELEMENT_NS: 
                case START_ELEMENT_GENERIC: 
                case START_ELEMENT_GENERIC_UNDECLARED: {
                    this.scDecoder.decodeStartElement();
                    break;
                }
                default: {
                    throw new RuntimeException("[EXI] Unsupported EventType " + (Object)((Object)et) + " in SelfContained Element");
                }
            }
        } else {
            this.scDecoder.decodeStartSelfContainedFragment();
        }
    }

    @Override
    public QNameContext decodeEndElement() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeEndElement();
        }
        return this.scDecoder.decodeEndElement();
    }

    @Override
    public String getElementPrefix() {
        return this.scDecoder == null ? super.getElementPrefix() : this.scDecoder.getElementPrefix();
    }

    @Override
    public String getElementQNameAsString() {
        return this.scDecoder == null ? super.getElementQNameAsString() : this.scDecoder.getElementQNameAsString();
    }

    @Override
    public QNameContext decodeAttributeXsiNil() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeAttributeXsiNil();
        }
        return this.scDecoder.decodeAttributeXsiNil();
    }

    @Override
    public QNameContext decodeAttributeXsiType() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeAttributeXsiType();
        }
        return this.scDecoder.decodeAttributeXsiType();
    }

    @Override
    public QNameContext decodeAttribute() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeAttribute();
        }
        return this.scDecoder.decodeAttribute();
    }

    @Override
    public String getAttributePrefix() {
        return this.scDecoder == null ? super.getAttributePrefix() : this.scDecoder.getAttributePrefix();
    }

    @Override
    public String getAttributeQNameAsString() {
        return this.scDecoder == null ? super.getAttributeQNameAsString() : this.scDecoder.getAttributeQNameAsString();
    }

    @Override
    public Value getAttributeValue() {
        return this.scDecoder == null ? super.getAttributeValue() : this.scDecoder.getAttributeValue();
    }

    @Override
    public List<NamespaceDeclaration> getDeclaredPrefixDeclarations() {
        if (this.scDecoder == null) {
            return super.getDeclaredPrefixDeclarations();
        }
        return this.scDecoder.getDeclaredPrefixDeclarations();
    }

    @Override
    public NamespaceDeclaration decodeNamespaceDeclaration() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeNamespaceDeclaration();
        }
        return this.scDecoder.decodeNamespaceDeclaration();
    }

    @Override
    public Value decodeCharacters() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeCharacters();
        }
        return this.scDecoder.decodeCharacters();
    }

    @Override
    public DocType decodeDocType() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeDocType();
        }
        return this.scDecoder.decodeDocType();
    }

    @Override
    public char[] decodeEntityReference() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeEntityReference();
        }
        return this.scDecoder.decodeEntityReference();
    }

    @Override
    public char[] decodeComment() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeComment();
        }
        return this.scDecoder.decodeComment();
    }

    @Override
    public ProcessingInstruction decodeProcessingInstruction() throws EXIException, IOException {
        if (this.scDecoder == null) {
            return super.decodeProcessingInstruction();
        }
        return this.scDecoder.decodeProcessingInstruction();
    }
}

