/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processor.tdml;

import geny.Readable$;
import geny.Writable$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.lib.externalvars.Binding;
import org.apache.daffodil.lib.iapi.TDMLImplementation;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.processor.tdml.DaffodilCTDMLParseResult;
import org.apache.daffodil.processor.tdml.DaffodilCTDMLParseResult$;
import org.apache.daffodil.processor.tdml.DaffodilCTDMLUnparseResult;
import org.apache.daffodil.processor.tdml.DaffodilCTDMLUnparseResult$;
import org.apache.daffodil.runtime1.processors.Failure$;
import org.apache.daffodil.runtime1.processors.ProcessorResult;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.parsers.ParseError;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError;
import org.apache.daffodil.tdml.processor.TDMLDFDLProcessor;
import org.apache.daffodil.tdml.processor.TDMLParseResult;
import org.apache.daffodil.tdml.processor.TDMLUnparseResult;
import os.CommandResult;
import os.Path;
import os.PathChunk;
import os.Pipe$;
import os.ProcessInput;
import os.ProcessOutput;
import os.ReadablePath;
import os.RelPath$;
import os.Shellable;
import os.Shellable$;
import os.Source;
import os.Source$;
import os.SubprocessException;
import os.proc;
import os.proc$;
import os.read;
import os.remove;
import os.size$;
import os.temp$;
import os.write$;
import scala.Function1;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.xml.Node;

public final class DaffodilCTDMLDFDLProcessor
implements TDMLDFDLProcessor {
    private final Path executable;

    public DaffodilCTDMLDFDLProcessor(Path executable) {
        this.executable = executable;
    }

    public DaffodilCTDMLDFDLProcessor withTracing(boolean onOff) {
        return this;
    }

    public DaffodilCTDMLDFDLProcessor withDebugger(Object db) {
        return this;
    }

    public DaffodilCTDMLDFDLProcessor withValidation(String validation) {
        return this;
    }

    public DaffodilCTDMLDFDLProcessor withExternalDFDLVariables(Seq<Binding> externalVarBindings) {
        return this;
    }

    public TDMLParseResult parse(InputStream input, long lengthLimitInBits) {
        DaffodilCTDMLParseResult daffodilCTDMLParseResult;
        Path tempDir = temp$.MODULE$.dir(null, TDMLImplementation.DaffodilC$.MODULE$.toString(), temp$.MODULE$.dir$default$3(), temp$.MODULE$.dir$default$4());
        Path infile = tempDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"infile"})));
        Path outfile = tempDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"outfile"})));
        write$.MODULE$.apply(infile, (Source)Source$.MODULE$.WritableSource((Object)input, (Function1 & Serializable)t -> Writable$.MODULE$.readableWritable(t, (Function1 & Serializable)i -> Readable$.MODULE$.InputStreamReadable(i))), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
        long inputSizeInBits = size$.MODULE$.apply(infile) * 8L;
        if (inputSizeInBits != lengthLimitInBits) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)(infile + " has " + inputSizeInBits + " bits, but needed " + lengthLimitInBits + " bits"));
        }
        try {
            try {
                proc proc2 = proc$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.PathShellable(this.executable), Shellable$.MODULE$.StringShellable("-o"), Shellable$.MODULE$.PathShellable(outfile), Shellable$.MODULE$.StringShellable("parse"), Shellable$.MODULE$.PathShellable(infile)}));
                Pipe$ pipe$ = Pipe$.MODULE$;
                Map map = proc2.call$default$2();
                ProcessInput processInput = proc2.call$default$3();
                ProcessOutput processOutput = proc2.call$default$4();
                boolean bl = proc2.call$default$6();
                long l = proc2.call$default$7();
                boolean bl2 = proc2.call$default$8();
                boolean bl3 = proc2.call$default$9();
                long l2 = proc2.call$default$10();
                boolean bl4 = proc2.call$default$11();
                CommandResult result = proc2.call(tempDir, map, processInput, processOutput, (ProcessOutput)pipe$, bl, l, bl2, bl3, l2, bl4);
                String messages = result.chunks().nonEmpty() ? result.toString() : "";
                daffodilCTDMLParseResult = new DaffodilCTDMLParseResult(lengthLimitInBits, outfile, (ProcessorResult)Success$.MODULE$, messages);
            }
            catch (SubprocessException e) {
                ParseError parseError = new ParseError(Maybe$.MODULE$.Nope(), Maybe$.MODULE$.Nope(), Maybe$.MODULE$.apply((Object)e), Maybe$.MODULE$.Nope(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                daffodilCTDMLParseResult = new DaffodilCTDMLParseResult(lengthLimitInBits, outfile, (ProcessorResult)Failure$.MODULE$.apply((Diagnostic)parseError), DaffodilCTDMLParseResult$.MODULE$.$lessinit$greater$default$4());
            }
        }
        finally {
            remove.all$.MODULE$.apply(tempDir);
        }
        DaffodilCTDMLParseResult parseResult = daffodilCTDMLParseResult;
        return parseResult;
    }

    public TDMLUnparseResult unparse(Node infosetXML, OutputStream output) {
        DaffodilCTDMLUnparseResult daffodilCTDMLUnparseResult;
        Path tempDir = temp$.MODULE$.dir(null, TDMLImplementation.DaffodilC$.MODULE$.toString(), temp$.MODULE$.dir$default$3(), temp$.MODULE$.dir$default$4());
        Path infile = tempDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"infile"})));
        Path outfile = tempDir.$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"outfile"})));
        write$.MODULE$.apply(infile, (Source)Source$.MODULE$.WritableSource((Object)infosetXML.toString(), (Function1 & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
        try {
            try {
                proc proc2 = proc$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.PathShellable(this.executable), Shellable$.MODULE$.StringShellable("-o"), Shellable$.MODULE$.PathShellable(outfile), Shellable$.MODULE$.StringShellable("unparse"), Shellable$.MODULE$.PathShellable(infile)}));
                Pipe$ pipe$ = Pipe$.MODULE$;
                Map map = proc2.call$default$2();
                ProcessInput processInput = proc2.call$default$3();
                ProcessOutput processOutput = proc2.call$default$4();
                boolean bl = proc2.call$default$6();
                long l = proc2.call$default$7();
                boolean bl2 = proc2.call$default$8();
                boolean bl3 = proc2.call$default$9();
                long l2 = proc2.call$default$10();
                boolean bl4 = proc2.call$default$11();
                CommandResult result = proc2.call(tempDir, map, processInput, processOutput, (ProcessOutput)pipe$, bl, l, bl2, bl3, l2, bl4);
                read.stream$.MODULE$.apply((ReadablePath)outfile).writeBytesTo(output);
                long finalBitPos0b = size$.MODULE$.apply(outfile) * 8L;
                String messages = result.chunks().nonEmpty() ? result.toString() : "";
                daffodilCTDMLUnparseResult = new DaffodilCTDMLUnparseResult(finalBitPos0b, (ProcessorResult)Success$.MODULE$, messages);
            }
            catch (SubprocessException e) {
                long finalBitPos0b = size$.MODULE$.apply(outfile) * 8L;
                UnparseError unparseError = new UnparseError(Maybe$.MODULE$.Nope(), Maybe$.MODULE$.Nope(), Maybe$.MODULE$.apply((Object)e), Maybe$.MODULE$.Nope(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                daffodilCTDMLUnparseResult = new DaffodilCTDMLUnparseResult(finalBitPos0b, (ProcessorResult)Failure$.MODULE$.apply((Diagnostic)unparseError), DaffodilCTDMLUnparseResult$.MODULE$.$lessinit$greater$default$3());
            }
        }
        finally {
            remove.all$.MODULE$.apply(tempDir);
        }
        DaffodilCTDMLUnparseResult unparseResult = daffodilCTDMLUnparseResult;
        return unparseResult;
    }

    public TDMLUnparseResult unparse(TDMLParseResult parseResult, OutputStream outStream) {
        Node infosetXML = parseResult.getResult();
        TDMLUnparseResult res = this.unparse(infosetXML, outStream);
        return res;
    }
}

