/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.elab.FallbackElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.NoDynamicContextException;

public abstract class ComplexNodePushElaborator
extends FallbackElaborator {
    @Override
    public PullEvaluator elaborateForPull() {
        PushEvaluator pushEval = this.elaborateForPush();
        return context -> {
            Controller controller = context.getController();
            if (controller == null) {
                throw new NoDynamicContextException("No controller available");
            }
            SequenceCollector seq = controller.allocateSequenceOutputter(1);
            TailCall tc = pushEval.processLeavingTail(new ComplexContentOutputter(seq), context);
            Expression.dispatchTailCall(tc);
            seq.close();
            SequenceIterator result = seq.iterate();
            seq.reset();
            return result;
        };
    }

    @Override
    public ItemEvaluator elaborateForItem() {
        PushEvaluator pushEval = this.elaborateForPush();
        return context -> {
            Controller controller = context.getController();
            if (controller == null) {
                throw new NoDynamicContextException("No controller available");
            }
            SequenceCollector seq = controller.allocateSequenceOutputter(1);
            TailCall tc = pushEval.processLeavingTail(new ComplexContentOutputter(seq), context);
            Expression.dispatchTailCall(tc);
            seq.close();
            Item result = seq.getFirstItem();
            seq.reset();
            return result;
        };
    }

    @Override
    public PushEvaluator elaborateForPush() {
        throw new UnsupportedOperationException();
    }
}

