/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;

public class BaseUri_1
extends SystemFunction
implements Callable {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo node = (NodeInfo)arguments[0].head();
        if (node == null) {
            return EmptySequence.getInstance();
        }
        String s = node.getBaseURI();
        if (s == null) {
            return EmptySequence.getInstance();
        }
        return new AnyURIValue(s);
    }

    @Override
    public Elaborator getElaborator() {
        return new BaseUriFnElaborator();
    }

    public static class BaseUriFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            boolean nullable = Cardinality.allowsZero(arg.getCardinality());
            ItemEvaluator argEval = arg.makeElaborator().elaborateForItem();
            return context -> {
                NodeInfo node = (NodeInfo)argEval.eval(context);
                if (nullable && node == null) {
                    return null;
                }
                String s = node.getBaseURI();
                if (s == null) {
                    return null;
                }
                return new AnyURIValue(s);
            };
        }
    }
}

