/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.lang.ref.Cleaner;
import net.sf.saxon.Configuration;

public class CleanerProxy {
    private final Cleaner cleaner;

    private CleanerProxy(Cleaner cleaner) {
        this.cleaner = cleaner;
    }

    public static CleanerProxy makeCleanerProxy(Configuration config) {
        try {
            Class.forName("java.lang.ref.Cleaner", true, config.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return new CleanerProxy(null);
        }
        Cleaner c = null;
        try {
            c = Cleaner.create();
        }
        catch (Exception e) {
            System.err.println("Warning: no Cleaner available (this is expected on Java 8)");
        }
        return new CleanerProxy(c);
    }

    public CleanableProxy registerCleanupAction(Object obj, Runnable runnable) {
        if (this.cleaner != null) {
            Cleaner.Cleanable cleanable = this.cleaner.register(obj, runnable);
            return new CleanableProxy(cleanable);
        }
        return null;
    }

    public static class CleanableProxy {
        private final Cleaner.Cleanable cleanable;

        public CleanableProxy(Cleaner.Cleanable cleanable) {
            this.cleanable = cleanable;
        }

        public void clean() {
            this.cleanable.clean();
        }
    }
}

