/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;

public class SerializationParamsHandler {
    public static final NamespaceUri NAMESPACE = NamespaceUri.OUTPUT;
    Properties properties;
    CharacterMap characterMap;
    Location locator;

    public SerializationParamsHandler() {
    }

    public SerializationParamsHandler(Properties props) {
        this.properties = props;
    }

    public void setLocator(Location locator) {
        this.locator = locator;
    }

    public void setSerializationParams(NodeInfo node) throws XPathException {
        NodeInfo child;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (node.getNodeKind() == 9) {
            node = Navigator.getOutermostElement(node.getTreeInfo());
        }
        if (node.getNodeKind() != 1) {
            throw new XPathException("Serialization params: node must be a document or element node");
        }
        if (!node.getLocalPart().equals("serialization-parameters")) {
            throw new XPathException("Serialization params: element name must be 'serialization-parameters'");
        }
        if (!node.getNamespaceUri().equals(NAMESPACE)) {
            throw new XPathException("Serialization params: element namespace must be " + NAMESPACE);
        }
        SerializationParamsHandler.restrictAttributes(node, new String[0]);
        HashSet<NodeName> nodeNames = new HashSet<NodeName>();
        AxisIterator kids = node.iterateAxis(3, NodeKindTest.ELEMENT);
        while ((child = kids.next()) != null) {
            if (!nodeNames.add(NameOfNode.makeName(child))) {
                throw new XPathException("Duplicated serialization parameter " + child.getDisplayName(), "SEPM0019");
            }
            String lname = child.getLocalPart();
            NamespaceUri uri = child.getNamespaceUri();
            if (uri.isEmpty()) {
                throw new XPathException("Serialization parameter " + lname + " is in no namespace", "SEPM0017");
            }
            if (NamespaceUri.OUTPUT.equals(uri)) {
                uri = NamespaceUri.NULL;
            }
            if (uri.isEmpty() && lname.equals("use-character-maps")) {
                NodeInfo gChild;
                SerializationParamsHandler.restrictAttributes(child, new String[0]);
                AxisIterator gKids = child.iterateAxis(3, NodeKindTest.ELEMENT);
                IntHashMap<String> map = new IntHashMap<String>();
                while ((gChild = gKids.next()) != null) {
                    SerializationParamsHandler.restrictAttributes(gChild, "character", "map-string");
                    if (!(gChild.getNamespaceUri().equals(NAMESPACE) && gChild.getLocalPart().equals("character-map") || !gChild.getNamespaceUri().equals(NAMESPACE) && !gChild.getNamespaceUri().isEmpty())) {
                        throw new XPathException("Invalid child of use-character-maps: " + gChild.getDisplayName(), "SEPM0017");
                    }
                    String ch = SerializationParamsHandler.getAttribute(gChild, "character");
                    String str = SerializationParamsHandler.getAttribute(gChild, "map-string");
                    StringValue chValue = new StringValue(ch);
                    if (chValue.length() != 1L) {
                        throw new XPathException("In the serialization parameters, the value of @character in the character map must be a single Unicode character", "SEPM0017");
                    }
                    int code = chValue.getContent().codePointAt(0L);
                    String prev = map.put(code, str);
                    if (prev == null) continue;
                    throw new XPathException("In the serialization parameters, the character map contains two entries for the character \\u" + Integer.toHexString(65536 + code).substring(1), "SEPM0018");
                }
                this.characterMap = new CharacterMap(NameOfNode.makeName(node).getStructuredQName(), map);
                continue;
            }
            SerializationParamsHandler.restrictAttributes(child, "value");
            String value = SerializationParamsHandler.getAttribute(child, "value");
            try {
                ResultDocument.setSerializationProperty(this.properties, uri, lname, value, child.getAllNamespaces(), false, node.getConfiguration());
            }
            catch (XPathException err) {
                if (err.hasErrorCode("XQST0109", "SEPM0016")) {
                    if (!uri.isEmpty()) continue;
                    throw err.withErrorCode("SEPM0017").maybeWithLocation(this.locator);
                }
                throw err;
            }
        }
    }

    private static void restrictAttributes(NodeInfo element, String ... allowedNames) throws XPathException {
        for (AttributeInfo att : element.attributes()) {
            NodeName name = att.getNodeName();
            if (!name.hasURI(NamespaceUri.NULL) || Arrays.binarySearch(allowedNames, name.getLocalPart()) >= 0) continue;
            throw new XPathException("In serialization parameters, attribute @" + name.getLocalPart() + " must not appear on element " + element.getDisplayName(), "SEPM0017");
        }
    }

    private static String getAttribute(NodeInfo element, String localName) throws XPathException {
        String value = element.getAttributeValue(NamespaceUri.NULL, localName);
        if (value == null) {
            throw new XPathException("In serialization parameters, attribute @" + localName + " is missing on element " + element.getDisplayName());
        }
        return value;
    }

    public SerializationProperties getSerializationProperties() {
        CharacterMapIndex index = new CharacterMapIndex();
        if (this.characterMap != null) {
            index.putCharacterMap(NamespaceUri.NULL.qName("charMap"), this.characterMap);
            this.properties.setProperty("use-character-maps", "charMap");
        }
        return new SerializationProperties(this.properties, index);
    }

    public CharacterMap getCharacterMap() {
        return this.characterMap;
    }
}

