/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.BuiltInRules;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SimpleType;

public class DeepCopyRuleSet
implements BuiltInRuleSet {
    private static final DeepCopyRuleSet THE_INSTANCE = new DeepCopyRuleSet();

    public static DeepCopyRuleSet getInstance() {
        return THE_INSTANCE;
    }

    private DeepCopyRuleSet() {
    }

    @Override
    public void process(Item item, ParameterSet parameters, ParameterSet tunnelParams, Outputter out, XPathContext context, Location locationId) throws XPathException {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 1: 
                case 9: {
                    if (out.getSystemId() == null) {
                        out.setSystemId(node.getBaseURI());
                    }
                    Navigator.copy(node, out, 6, locationId);
                    return;
                }
                case 3: {
                    out.characters(item.getUnicodeStringValue(), locationId, 0);
                    return;
                }
                case 8: {
                    out.comment(node.getUnicodeStringValue(), locationId, 0);
                    return;
                }
                case 7: {
                    out.processingInstruction(node.getLocalPart(), node.getUnicodeStringValue(), locationId, 0);
                    return;
                }
                case 2: {
                    out.attribute(NameOfNode.makeName(node), (SimpleType)node.getSchemaType(), node.getStringValue(), locationId, 0);
                    return;
                }
                case 13: {
                    out.namespace(node.getLocalPart(), NamespaceUri.of(node.getStringValue()), 0);
                    return;
                }
            }
        } else {
            out.append(item, locationId, 0);
        }
    }

    @Override
    public BuiltInRules[] getActionForParentNodes(int nodeKind) {
        return new BuiltInRules[]{BuiltInRules.DEEP_COPY};
    }

    @Override
    public String getName() {
        return "deep-copy";
    }
}

