/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.LearningEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;

public abstract class Closure
implements Sequence,
ContextOriginator {
    protected PullEvaluator inputEvaluator;
    protected XPathContextMajor savedXPathContext;
    protected int depth = 0;
    protected LearningEvaluator learningEvaluator;
    protected int serialNumber;
    protected Expression expression;
    protected SequenceIterator inputIterator;

    public void saveContext(Expression expression, XPathContext context) throws XPathException {
        StackFrame localStackFrame;
        this.expression = expression;
        if ((expression.getDependencies() & 0x80) != 0) {
            localStackFrame = context.getStackFrame();
            Sequence[] local = localStackFrame.getStackFrameValues();
            int[] slotsUsed = expression.getSlotsUsed();
            if (local != null) {
                SlotManager stackFrameMap = localStackFrame.getStackFrameMap();
                Sequence[] savedStackFrame = new Sequence[stackFrameMap.getNumberOfVariables()];
                for (int i : slotsUsed) {
                    if (local[i] instanceof Closure) {
                        int cdepth = ((Closure)local[i]).depth;
                        if (cdepth >= 10) {
                            try {
                                local[i] = SequenceTool.toGroundedValue(local[i].iterate());
                            }
                            catch (UncheckedXPathException e) {
                                throw e.getXPathException();
                            }
                        } else if (cdepth + 1 > this.depth) {
                            this.depth = cdepth + 1;
                        }
                    }
                    savedStackFrame[i] = local[i];
                }
                this.savedXPathContext.setStackFrame(stackFrameMap, savedStackFrame);
            }
        } else if ((expression.getDependencies() & 0x1000) != 0) {
            localStackFrame = context.getStackFrame();
            SlotManager stackFrameMap = localStackFrame.getStackFrameMap();
            Sequence[] savedStackFrame = new Sequence[stackFrameMap.getNumberOfVariables()];
            this.savedXPathContext.setStackFrame(stackFrameMap, savedStackFrame);
        }
        FocusIterator currentIterator = context.getCurrentIterator();
        if (currentIterator != null) {
            Item contextItem = currentIterator.current();
            ManualIterator single = new ManualIterator(contextItem);
            this.savedXPathContext.setCurrentIterator(single);
        }
    }

    public void setLearningEvaluator(LearningEvaluator learningEvaluator, int serialNumber) {
        this.learningEvaluator = learningEvaluator;
        this.serialNumber = serialNumber;
    }

    @Override
    public Item head() throws XPathException {
        try {
            return this.iterate().next();
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    public XPathContextMajor getSavedXPathContext() {
        return this.savedXPathContext;
    }

    public void setInputEvaluator(PullEvaluator inputEvaluator) {
        this.inputEvaluator = inputEvaluator;
    }

    public void setSavedXPathContext(XPathContextMajor savedXPathContext) {
        this.savedXPathContext = savedXPathContext;
    }

    @Override
    public abstract SequenceIterator iterate();

    public GroundedValue reduce() throws XPathException {
        return SequenceTool.toGroundedValue(this.iterate());
    }

    @Override
    public Sequence makeRepeatable() throws XPathException {
        return this.materialize();
    }

    public Expression getExpression() {
        return this.expression;
    }
}

