/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketchBuilder;
import org.apache.datasketches.quantiles.QuantilesDoublesUnion;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DirectUpdateDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        QuantilesDoublesSketch.rand.setSeed(32749L);
    }

    @Test
    public void checkSmallMinMax() {
        int k = 32;
        int n = 8;
        UpdatableQuantilesDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildDQS(32, 8L);
        UpdatableQuantilesDoublesSketch qs2 = DirectUpdateDoublesSketchTest.buildDQS(32, 8L);
        UpdatableQuantilesDoublesSketch qs3 = DirectUpdateDoublesSketchTest.buildDQS(32, 8L);
        for (int i = 8; i >= 1; --i) {
            qs1.update((double)i);
            qs2.update((double)(10 + i));
            qs3.update((double)i);
        }
        Assert.assertEquals((double)qs1.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)qs1.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)qs1.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        Assert.assertEquals((double)qs2.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)11.0);
        Assert.assertEquals((double)qs2.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)15.0);
        Assert.assertEquals((double)qs2.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)18.0);
        Assert.assertEquals((double)qs3.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)qs3.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)qs3.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        double[] queries = new double[]{0.0, 0.5, 1.0};
        double[] resultsA = qs1.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsA[0], (double)1.0);
        Assert.assertEquals((double)resultsA[1], (double)5.0);
        Assert.assertEquals((double)resultsA[2], (double)8.0);
        QuantilesDoublesUnion union1 = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs1);
        union1.union((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch result1 = union1.getResult();
        QuantilesDoublesUnion union2 = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs2);
        union2.union((QuantilesDoublesSketch)qs3);
        UpdatableQuantilesDoublesSketch result2 = union2.getResult();
        double[] resultsB = result1.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        DirectUpdateDoublesSketchTest.printResults(resultsB);
        Assert.assertEquals((double)resultsB[0], (double)1.0);
        Assert.assertEquals((double)resultsB[1], (double)11.0);
        Assert.assertEquals((double)resultsB[2], (double)18.0);
        double[] resultsC = result2.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsC[0], (double)1.0);
        Assert.assertEquals((double)resultsC[1], (double)11.0);
        Assert.assertEquals((double)resultsC[2], (double)18.0);
    }

    static void printResults(double[] results) {
        DirectUpdateDoublesSketchTest.println(results[0] + ", " + results[1] + ", " + results[2]);
    }

    @Test
    public void wrapEmptyUpdateSketch() {
        UpdatableQuantilesDoublesSketch s1 = QuantilesDoublesSketch.builder().build();
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(s1.toByteArray()).order(ByteOrder.nativeOrder()));
        DirectUpdateDoublesSketch s2 = DirectUpdateDoublesSketch.wrapInstance((MemorySegment)seg, null);
        Assert.assertTrue((boolean)s2.isEmpty());
        Assert.assertEquals((long)s2.getN(), (long)0L);
        Assert.assertTrue((boolean)Double.isNaN(s2.isEmpty() ? Double.NaN : s2.getMinItem()));
        Assert.assertTrue((boolean)Double.isNaN(s2.isEmpty() ? Double.NaN : s2.getMaxItem()));
        s2.reset();
        Assert.assertEquals((long)s2.getN(), (long)0L);
    }

    @Test
    public void checkPutCombinedBuffer() {
        int k = 128;
        int cap = 2080;
        MemorySegment seg = MemorySegment.ofArray(new byte[2080]);
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(128).build(seg);
        seg = qs.getMemorySegment();
        Assert.assertEquals((long)seg.byteSize(), (long)2080L);
        Assert.assertTrue((boolean)qs.isEmpty());
        int n = 16;
        double[] data = new double[16];
        for (int i = 0; i < 16; ++i) {
            data[i] = i + 1;
        }
        qs.putBaseBufferCount(16);
        qs.putN(16L);
        qs.putCombinedBuffer(data);
        double[] combBuf = qs.getCombinedBuffer();
        Assert.assertEquals((double[])combBuf, (double[])data);
        Assert.assertTrue((boolean)Double.isNaN(qs.getMinItem()));
        Assert.assertTrue((boolean)Double.isNaN(qs.getMaxItem()));
    }

    @Test
    public void checkMisc() {
        int k = 128;
        int n = 48;
        int cap = 2080;
        MemorySegment seg = MemorySegment.ofArray(new byte[2080]);
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(128).build(seg);
        seg = qs.getMemorySegment();
        Assert.assertEquals((long)seg.byteSize(), (long)2080L);
        double[] combBuf = qs.getCombinedBuffer();
        Assert.assertEquals((int)combBuf.length, (int)256);
        qs = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 48);
        qs.update(Double.NaN);
        int n2 = (int)qs.getN();
        Assert.assertEquals((int)n2, (int)48);
        combBuf = qs.getCombinedBuffer();
        Assert.assertEquals((int)combBuf.length, (int)Util.ceilingPowerOf2((int)48));
        DirectUpdateDoublesSketchTest.println(qs.toString(true, true));
        qs.reset();
        Assert.assertEquals((long)qs.getN(), (long)0L);
        qs.putBaseBufferCount(0);
    }

    @Test
    public void variousExceptions() {
        int flags2;
        MemorySegment seg = MemorySegment.ofArray(new byte[8]);
        try {
            flags2 = 8;
            DirectUpdateDoublesSketch.checkCompact((int)2, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException flags2) {
            // empty catch block
        }
        try {
            flags2 = 8;
            DirectUpdateDoublesSketch.checkCompact((int)3, (int)8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketch.checkPreLongs((int)3);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketch.checkPreLongs((int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketch.checkDirectFlags((int)8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketch.checkEmptyAndN((boolean)true, (long)1L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCheckDirectSegCapacity() {
        int k = 128;
        DirectUpdateDoublesSketch.checkDirectSegCapacity((int)128, (long)255L, (long)2080L);
        DirectUpdateDoublesSketch.checkDirectSegCapacity((int)128, (long)257L, (long)3104L);
        DirectUpdateDoublesSketch.checkDirectSegCapacity((int)128, (long)0L, (long)8L);
        try {
            DirectUpdateDoublesSketch.checkDirectSegCapacity((int)128, (long)10000L, (long)64L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void serializeDeserialize() {
        int sizeBytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)128, (long)2000L);
        MemorySegment seg = MemorySegment.ofArray(new byte[sizeBytes]);
        UpdatableQuantilesDoublesSketch sketch1 = QuantilesDoublesSketch.builder().build(seg);
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((double)i);
        }
        UpdatableQuantilesDoublesSketch sketch2 = UpdatableQuantilesDoublesSketch.wrap((MemorySegment)seg, null);
        for (int i = 0; i < 1000; ++i) {
            sketch2.update((double)(i + 1000));
        }
        Assert.assertEquals((double)sketch2.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1999.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)1000.0, (double)10.0);
        byte[] arr2 = sketch2.toByteArray(false);
        Assert.assertEquals((int)arr2.length, (int)sketch2.getSerializedSizeBytes());
        QuantilesDoublesSketch sketch3 = QuantilesDoublesSketch.writableWrap((MemorySegment)MemorySegment.ofArray(arr2), null);
        Assert.assertEquals((double)sketch3.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch3.getMaxItem(), (double)1999.0);
        Assert.assertEquals((double)sketch3.getQuantile(0.5), (double)1000.0, (double)10.0);
    }

    @Test
    public void mergeTest() {
        UpdatableQuantilesDoublesSketch dqs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 256);
        UpdatableQuantilesDoublesSketch dqs2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 256L, 256);
        QuantilesDoublesUnion union = QuantilesDoublesUnion.builder().setMaxK(128).build();
        union.union((QuantilesDoublesSketch)dqs1);
        union.union((QuantilesDoublesSketch)dqs2);
        UpdatableQuantilesDoublesSketch result = union.getResult();
        double median = result.getQuantile(0.5);
        DirectUpdateDoublesSketchTest.println("Median: " + median);
        Assert.assertEquals((double)median, (double)258.0, (double)12.9);
    }

    @Test
    public void checkSimplePropagateCarryDirect() {
        int k = 16;
        int n = 32;
        int segBytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)16, (long)32L);
        MemorySegment seg = MemorySegment.ofArray(new byte[segBytes]);
        QuantilesDoublesSketchBuilder bldr = QuantilesDoublesSketch.builder();
        UpdatableQuantilesDoublesSketch ds = bldr.setK(16).build(seg);
        for (int i = 1; i <= 32; ++i) {
            ds.update((double)i);
        }
        double last = 0.0;
        for (int i = 0; i < 16; ++i) {
            double d = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)(36 + i << 3));
            Assert.assertTrue((d > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((d > last ? 1 : 0) != 0);
            last = d;
        }
    }

    @Test
    public void getRankAndGetCdfConsistency() {
        int k = 128;
        int n = 1000000;
        int segBytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)128, (long)1000000L);
        MemorySegment seg = MemorySegment.ofArray(new byte[segBytes]);
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build(seg);
        double[] values = new double[1000000];
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((double)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        for (int i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]));
        }
    }

    static UpdatableQuantilesDoublesSketch buildAndLoadDQS(int k, int n) {
        return DirectUpdateDoublesSketchTest.buildAndLoadDQS(k, n, 0);
    }

    static UpdatableQuantilesDoublesSketch buildAndLoadDQS(int k, long n, int startV) {
        UpdatableQuantilesDoublesSketch qs = DirectUpdateDoublesSketchTest.buildDQS(k, n);
        for (long i = 1L; i <= n; ++i) {
            qs.update((double)((long)startV + i));
        }
        return qs;
    }

    static UpdatableQuantilesDoublesSketch buildDQS(int k, long n) {
        int cap = QuantilesDoublesSketch.getUpdatableStorageBytes((int)k, (long)n);
        if (cap < 2 * k) {
            cap = 2 * k;
        }
        QuantilesDoublesSketchBuilder bldr = new QuantilesDoublesSketchBuilder();
        bldr.setK(k);
        return bldr.build(MemorySegment.ofArray(new byte[cap]));
    }

    @Test
    public void printlnTest() {
        DirectUpdateDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        DirectUpdateDoublesSketchTest.print(s + Util.LS);
    }

    static void print(String s) {
    }
}

