/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.causality;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.shaded.org.apache.ignite.internal.causality.BaseVersionedValue;
import org.apache.ignite.shaded.org.apache.ignite.internal.causality.CompletionListener;
import org.apache.ignite.shaded.org.apache.ignite.internal.causality.DeletionListener;
import org.apache.ignite.shaded.org.apache.ignite.internal.causality.RevisionListener;
import org.apache.ignite.shaded.org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.shaded.org.apache.ignite.internal.causality.VersionedValue;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class IncrementalVersionedValue<T>
implements VersionedValue<T> {
    private final BaseVersionedValue<T> versionedValue;
    private final Object updateMutex = new Object();
    private long expectedToken = -1L;
    private long lastCompleteToken = -1L;
    private long lastDeletedToken = -1L;
    private CompletableFuture<T> updaterFuture;

    public static RevisionListenerRegistry dependingOn(IncrementalVersionedValue<?> vv) {
        return listener -> {
            vv.whenComplete((token, value, ex) -> listener.onUpdate(token));
            vv.whenDelete(listener::onDelete);
        };
    }

    public IncrementalVersionedValue(String name, @Nullable RevisionListenerRegistry registry, int maxHistorySize, @Nullable Supplier<T> defaultValueSupplier) {
        this.versionedValue = new BaseVersionedValue<T>(name, maxHistorySize, defaultValueSupplier);
        this.updaterFuture = CompletableFuture.completedFuture(this.versionedValue.getDefault());
        if (registry != null) {
            registry.listen(new RevisionListener(){

                @Override
                public CompletableFuture<?> onUpdate(long revision) {
                    return IncrementalVersionedValue.this.completeInternal(revision);
                }

                @Override
                public void onDelete(long revisionUpperBoundInclusive) {
                    IncrementalVersionedValue.this.deleteInternal(revisionUpperBoundInclusive);
                }
            });
        }
    }

    public IncrementalVersionedValue(String name, @Nullable RevisionListenerRegistry registry, @Nullable Supplier<T> defaultValueSupplier) {
        this(name, registry, 10, defaultValueSupplier);
    }

    public IncrementalVersionedValue(String name, RevisionListenerRegistry registry) {
        this(name, registry, 10, null);
    }

    @Override
    public String name() {
        return this.versionedValue.name();
    }

    @Override
    public CompletableFuture<T> get(long causalityToken) {
        return this.versionedValue.get(causalityToken);
    }

    @Override
    @Nullable
    public T latest() {
        return this.versionedValue.latest();
    }

    @Override
    public long latestCausalityToken() {
        return this.versionedValue.latestCausalityToken();
    }

    @Override
    public void whenComplete(CompletionListener<T> action) {
        this.versionedValue.whenComplete(action);
    }

    @Override
    public void removeWhenComplete(CompletionListener<T> action) {
        this.versionedValue.removeWhenComplete(action);
    }

    @Override
    public void whenDelete(DeletionListener<T> action) {
        this.versionedValue.whenDelete(action);
    }

    @Override
    public void removeWhenDelete(DeletionListener<T> action) {
        this.versionedValue.removeWhenDelete(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> update(long causalityToken, BiFunction<T, Throwable, CompletableFuture<T>> updater) {
        Object object = this.updateMutex;
        synchronized (object) {
            if (this.expectedToken == -1L) {
                assert (causalityToken > this.lastCompleteToken) : String.format("Causality token is outdated, previous token %d, got %d", this.lastCompleteToken, causalityToken);
                this.expectedToken = causalityToken;
            } else assert (this.expectedToken == causalityToken) : String.format("Causality token mismatch, expected %d, got %d", this.expectedToken, causalityToken);
            this.updaterFuture = ((CompletableFuture)this.updaterFuture.handle(updater)).thenCompose(Function.identity());
            return this.updaterFuture;
        }
    }

    public void complete(long causalityToken) {
        this.completeInternal(causalityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeExceptionally(long causalityToken, Throwable throwable) {
        Object object = this.updateMutex;
        synchronized (object) {
            this.updaterFuture = CompletableFuture.failedFuture(throwable);
            this.completeInternal(causalityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> completeInternal(long causalityToken) {
        Object object = this.updateMutex;
        synchronized (object) {
            assert (this.expectedToken == -1L || this.expectedToken == causalityToken) : String.format("Causality token mismatch, expected %d, got %d", this.expectedToken, causalityToken);
            assert (causalityToken > this.lastCompleteToken) : String.format("Causality token must be greater than the last completed: [token=%s, lastCompleted=%s]", causalityToken, this.lastCompleteToken);
            assert (causalityToken > this.lastDeletedToken) : String.format("Causality token must be greater than the last deleted: [token=%s, lastDeleted=%s]", causalityToken, this.lastDeletedToken);
            this.lastCompleteToken = causalityToken;
            this.expectedToken = -1L;
            CompletableFuture<T> localUpdaterFuture = this.updaterFuture;
            if (this.updaterFuture.isDone()) {
                this.updaterFuture.whenComplete((T v, U t) -> this.versionedValue.complete(causalityToken, localUpdaterFuture));
            } else {
                this.updaterFuture = this.updaterFuture.whenComplete((T v, U t) -> this.versionedValue.complete(causalityToken, localUpdaterFuture));
            }
            return this.updaterFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInternal(long causalityToken) {
        Object object = this.updateMutex;
        synchronized (object) {
            assert (causalityToken < this.lastCompleteToken) : String.format("Causality token must be less than the last completed: [name=%s, token=%s, lastCompleted=%s]", this.name(), causalityToken, this.lastCompleteToken);
            assert (causalityToken > this.lastDeletedToken) : String.format("Causality token must be greater than the last deleted: [name=%s, token=%s, lastDeleted=%s]", this.name(), causalityToken, this.lastDeletedToken);
            this.lastDeletedToken = causalityToken;
            this.versionedValue.deleteUpTo(causalityToken);
        }
    }
}

