/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.DeployMessagingService;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.DeploymentUnit;
import org.apache.ignite.internal.deployunit.DownloadTracker;
import org.apache.ignite.internal.deployunit.FileDeployerService;
import org.apache.ignite.internal.deployunit.UnitContent;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.CompletableFutures;

class UnitDownloader {
    private static final IgniteLogger LOG = Loggers.forClass(UnitDownloader.class);
    private final DeploymentUnitStore deploymentUnitStore;
    private final String nodeName;
    private final FileDeployerService deployer;
    private final DownloadTracker tracker;
    private final DeployMessagingService messaging;

    UnitDownloader(DeploymentUnitStore deploymentUnitStore, String nodeName, FileDeployerService deployer, DownloadTracker tracker, DeployMessagingService messaging) {
        this.deploymentUnitStore = deploymentUnitStore;
        this.nodeName = nodeName;
        this.deployer = deployer;
        this.tracker = tracker;
        this.messaging = messaging;
    }

    CompletableFuture<Boolean> downloadUnit(Collection<UnitNodeStatus> statuses, String id, Version version) {
        List<String> deployedNodes = statuses.stream().filter(status -> status.status() == DeploymentStatus.DEPLOYED).map(UnitNodeStatus::nodeId).collect(Collectors.toList());
        return this.downloadUnit(id, version, deployedNodes);
    }

    CompletableFuture<Boolean> downloadUnit(String id, Version version, Collection<String> nodes) {
        return this.tracker.track(id, version, () -> this.deploymentUnitStore.getNodeStatus(this.nodeName, id, version).thenCompose(status -> {
            if (status.status() == DeploymentStatus.DEPLOYED) {
                return CompletableFutures.trueCompletedFuture();
            }
            return this.downloadUnitContent(id, version, nodes);
        }));
    }

    private CompletableFuture<Boolean> downloadUnitContent(String id, Version version, Collection<String> nodes) {
        return ((CompletableFuture)this.messaging.downloadUnitContent(id, version, nodes).thenCompose(content -> {
            DeploymentUnit unit = UnitContent.toDeploymentUnit(content);
            return this.deployer.deploy(id, version, unit).whenComplete((deployed, throwable) -> {
                try {
                    unit.close();
                }
                catch (Exception e) {
                    LOG.error("Error closing deployment unit", (Throwable)e);
                }
            });
        })).thenCompose(deployed -> {
            if (deployed.booleanValue()) {
                return this.deploymentUnitStore.updateNodeStatus(this.nodeName, id, version, DeploymentStatus.DEPLOYED);
            }
            return CompletableFutures.falseCompletedFuture();
        });
    }
}

