/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import java.util.UUID;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlUuidLiteral
extends SqlLiteral {
    public SqlUuidLiteral(UUID t, SqlParserPos pos) {
        super(t, SqlTypeName.UUID, pos);
    }

    @Override
    public SqlUuidLiteral clone(SqlParserPos pos) {
        return new SqlUuidLiteral(this.getUuid(), pos);
    }

    public UUID getUuid() {
        return (UUID)Objects.requireNonNull(this.value, "value");
    }

    @Override
    public String toString() {
        return "UUID '" + this.toFormattedString() + "'";
    }

    public String toFormattedString() {
        return this.getUuid().toString();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal(this.toString());
    }
}

