/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.exec.exp.IgniteExpressions;
import org.apache.ignite.internal.sql.engine.exec.exp.IgniteSqlFunctions;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;

public class ConverterUtils {
    private ConverterUtils() {
    }

    static Expression toInternal(Expression operand, Type targetType) {
        return ConverterUtils.toInternal(operand, operand.getType(), targetType);
    }

    private static Type toInternal(RelDataType type) {
        return ConverterUtils.toInternal(type, false);
    }

    private static Expression toInternal(Expression operand, Type fromType, Type targetType) {
        if (fromType == Date.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Time.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Timestamp.class) {
            if (targetType == Long.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Long.class) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        }
        return operand;
    }

    static Type toInternal(RelDataType type, boolean forceNotNull) {
        switch (type.getSqlTypeName()) {
            case DATE: 
            case TIME: {
                return type.isNullable() && !forceNotNull ? Integer.class : Integer.TYPE;
            }
            case TIMESTAMP: {
                return type.isNullable() && !forceNotNull ? Long.class : Long.TYPE;
            }
        }
        return null;
    }

    private static Expression fromInternal(Expression operand, Type targetType) {
        return ConverterUtils.fromInternal(operand, operand.getType(), targetType);
    }

    private static Expression fromInternal(Expression operand, Type fromType, Type targetType) {
        if (operand == ConstantUntypedNull.INSTANCE) {
            return operand;
        }
        if (!(operand.getType() instanceof Class)) {
            return operand;
        }
        if (Types.isAssignableFrom((Type)targetType, (Type)fromType)) {
            return operand;
        }
        if (targetType == Date.class) {
            if (ConverterUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_DATE.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Time.class) {
            if (ConverterUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIME.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Timestamp.class && ConverterUtils.isA(fromType, Primitive.LONG)) {
            return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand});
        }
        if (Primitive.is((Type)operand.type) && Primitive.isBox((Type)targetType)) {
            return Expressions.convert_((Expression)operand, (Type)Primitive.ofBox((Type)targetType).primitiveClass);
        }
        return operand;
    }

    static List<Expression> fromInternal(Class<?>[] targetTypes, List<Expression> expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == expressions.size()) {
            for (int i = 0; i < expressions.size(); ++i) {
                list.add(ConverterUtils.fromInternal(expressions.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (int i = 0; i < expressions.size(); ++i) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(ConverterUtils.fromInternal(expressions.get(i), type));
            }
        }
        return list;
    }

    static List<Type> internalTypes(List<? extends RexNode> operandList) {
        return Util.transform(operandList, node -> ConverterUtils.toInternal(node.getType()));
    }

    private static Expression convertToDecimal(Expression operand, RelDataType targetType) {
        assert (targetType.getSqlTypeName() == SqlTypeName.DECIMAL);
        return Expressions.call(IgniteSqlFunctions.class, (String)"toBigDecimal", (Expression[])new Expression[]{operand, Expressions.constant((Object)targetType.getPrecision()), Expressions.constant((Object)targetType.getScale())});
    }

    private static Expression convertToTime(Expression operand, RelDataType targetType) {
        assert (targetType.getSqlTypeName() == SqlTypeName.TIME);
        return Expressions.call(IgniteSqlFunctions.class, (String)"toTimeExact", (Expression[])new Expression[]{operand, Expressions.constant((Object)targetType.getPrecision())});
    }

    private static Expression convertToDate(Expression operand, RelDataType targetType) {
        assert (targetType.getSqlTypeName() == SqlTypeName.DATE);
        return Expressions.call(IgniteSqlFunctions.class, (String)"toDateExact", (Expression[])new Expression[]{operand});
    }

    private static Expression convertToTimestamp(Expression operand, RelDataType targetType) {
        String methodName;
        if (targetType.getSqlTypeName() == SqlTypeName.TIMESTAMP) {
            methodName = "toTimestampExact";
        } else {
            assert (targetType.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) : targetType;
            methodName = "toTimestampLtzExact";
        }
        return Expressions.call(IgniteSqlFunctions.class, (String)methodName, (Expression[])new Expression[]{operand, Expressions.constant((Object)targetType.getPrecision())});
    }

    public static Expression convert(Expression operand, RelDataType targetType) {
        if (SqlTypeUtil.isDecimal((RelDataType)targetType)) {
            return ConverterUtils.convertToDecimal(operand, targetType);
        }
        if (SqlTypeUtil.isDate((RelDataType)targetType)) {
            return ConverterUtils.convertToDate(operand, targetType);
        }
        if (SqlTypeUtil.isTimestamp((RelDataType)targetType)) {
            return ConverterUtils.convertToTimestamp(operand, targetType);
        }
        if (targetType.getSqlTypeName() == SqlTypeName.TIME) {
            return ConverterUtils.convertToTime(operand, targetType);
        }
        return ConverterUtils.convert(operand, Commons.typeFactory().getJavaClass(targetType));
    }

    private static Expression convert(Expression operand, Type toType) {
        Type fromType = operand.getType();
        if (!Types.needTypeCast((Type)fromType, (Type)toType)) {
            return operand;
        }
        if (toType == Void.class) {
            return RexImpTable.NULL_EXPR;
        }
        if (toType == BigDecimal.class) {
            throw new AssertionError((Object)"For conversion to decimal, ConverterUtils#convertToDecimal method should be used instead.");
        }
        Primitive toPrimitive = Primitive.of((Type)toType);
        Primitive fromPrimitive = Primitive.of((Type)fromType);
        boolean fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        Primitive fromBox = Primitive.ofBox((Type)fromType);
        if (toPrimitive != null) {
            if ((toPrimitive == Primitive.LONG || toPrimitive == Primitive.INT || toPrimitive == Primitive.SHORT || toPrimitive == Primitive.BYTE) && fromType == String.class) {
                return Expressions.call(IgniteMath.class, (String)("convertTo" + SqlFunctions.initcap((String)toPrimitive.primitiveName) + "Exact"), (Expression[])new Expression[]{operand});
            }
            if (fromPrimitive != null) {
                return IgniteExpressions.convertChecked(operand, fromPrimitive, toPrimitive);
            }
            if (fromNumber) {
                return IgniteExpressions.unboxChecked(operand, fromBox, toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap((String)toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
        }
        if (toType == String.class && fromType == BigDecimal.class) {
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(IgniteSqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand}));
        }
        if (toType == UUID.class && fromType == String.class) {
            return Expressions.call(UUID.class, (String)"fromString", (Expression[])new Expression[]{operand});
        }
        return EnumUtils.convert((Expression)operand, (Type)toType);
    }

    private static boolean isA(Type fromType, Primitive primitive) {
        return Primitive.of((Type)fromType) == primitive || Primitive.ofBox((Type)fromType) == primitive;
    }

    static List<Expression> convertAssignableTypes(Class<?>[] targetTypes, List<Expression> arguments) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == arguments.size()) {
            for (int i = 0; i < arguments.size(); ++i) {
                list.add(ConverterUtils.convertAssignableType(arguments.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (Expression argument : arguments) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(ConverterUtils.convertAssignableType(argument, type));
            }
        }
        return list;
    }

    private static Expression convertAssignableType(Expression argument, Type targetType) {
        if (targetType != BigDecimal.class) {
            return argument;
        }
        return ConverterUtils.convert(argument, targetType);
    }
}

