/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.failure.handlers;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.failure.handlers.FailureHandler;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public abstract class AbstractFailureHandler
implements FailureHandler {
    @IgniteToStringInclude
    private volatile Set<FailureType> ignoredFailureTypes = Collections.unmodifiableSet(EnumSet.of(FailureType.SYSTEM_WORKER_BLOCKED, FailureType.SYSTEM_CRITICAL_OPERATION_TIMEOUT));

    public void ignoredFailureTypes(Set<FailureType> failureTypes) {
        this.ignoredFailureTypes = Collections.unmodifiableSet(failureTypes);
    }

    public Set<FailureType> ignoredFailureTypes() {
        return this.ignoredFailureTypes;
    }

    public boolean onFailure(FailureContext failureCtx) {
        return !this.ignoredFailureTypes.contains(failureCtx.type()) && this.handle(failureCtx);
    }

    protected abstract boolean handle(FailureContext var1);

    public String toString() {
        return S.toString(AbstractFailureHandler.class, (Object)this);
    }
}

