/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.index;

import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;

public interface StorageIndexDescriptor {
    public int id();

    public List<? extends StorageColumnDescriptor> columns();

    public boolean mustBeBuilt();

    public static StorageIndexDescriptor create(CatalogTableDescriptor table, CatalogIndexDescriptor index) {
        if (index instanceof CatalogHashIndexDescriptor) {
            return new StorageHashIndexDescriptor(table, (CatalogHashIndexDescriptor)index);
        }
        if (index instanceof CatalogSortedIndexDescriptor) {
            return new StorageSortedIndexDescriptor(table, (CatalogSortedIndexDescriptor)index);
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(index));
    }

    public static NativeType getNativeType(CatalogTableColumnDescriptor column) {
        switch (column.type()) {
            case BOOLEAN: {
                return NativeTypes.BOOLEAN;
            }
            case INT8: {
                return NativeTypes.INT8;
            }
            case INT16: {
                return NativeTypes.INT16;
            }
            case INT32: {
                return NativeTypes.INT32;
            }
            case INT64: {
                return NativeTypes.INT64;
            }
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case DECIMAL: {
                return NativeTypes.decimalOf((int)column.precision(), (int)column.scale());
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: {
                return NativeTypes.time((int)column.precision());
            }
            case DATETIME: {
                return NativeTypes.datetime((int)column.precision());
            }
            case TIMESTAMP: {
                return NativeTypes.timestamp((int)column.precision());
            }
            case UUID: {
                return NativeTypes.UUID;
            }
            case STRING: {
                return NativeTypes.stringOf((int)column.length());
            }
            case BYTE_ARRAY: {
                return NativeTypes.blobOf((int)column.length());
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(column.type()));
    }

    public static interface StorageColumnDescriptor {
        public String name();

        public NativeType type();

        public boolean nullable();
    }
}

