/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

abstract class StorageOperation {
    private final CompletableFuture<Void> operationFuture = new CompletableFuture();
    private volatile boolean finalOperation;

    StorageOperation() {
    }

    CompletableFuture<Void> operationFuture() {
        return this.operationFuture;
    }

    boolean isFinalOperation() {
        return this.finalOperation;
    }

    void markFinalOperation() {
        this.finalOperation = true;
    }

    abstract String inProcessErrorMessage(String var1);

    static class CloseStorageOperation
    extends StorageOperation {
        CloseStorageOperation() {
        }

        @Override
        String inProcessErrorMessage(String storageInfo) {
            return "Storage is in the process of closing: [" + storageInfo + "]";
        }
    }

    static class CleanupStorageOperation
    extends StorageOperation {
        CleanupStorageOperation() {
        }

        @Override
        String inProcessErrorMessage(String storageInfo) {
            return "Storage is in process of being cleaned up: [" + storageInfo + "]";
        }
    }

    static class FinishRebalanceStorageOperation
    extends StorageOperation {
        FinishRebalanceStorageOperation() {
        }

        @Override
        String inProcessErrorMessage(String storageInfo) {
            return "Storage in the process of finishing a rebalance: [" + storageInfo + "]";
        }
    }

    static class AbortRebalanceStorageOperation
    extends StorageOperation {
        AbortRebalanceStorageOperation() {
        }

        @Override
        String inProcessErrorMessage(String storageInfo) {
            return "Storage in the process of aborting a rebalance: [" + storageInfo + "]";
        }
    }

    static class StartRebalanceStorageOperation
    extends StorageOperation {
        private final AtomicReference<AbortRebalanceStorageOperation> abortRebalanceOperation = new AtomicReference();
        private final CompletableFuture<Void> startRebalanceFuture = new CompletableFuture();

        StartRebalanceStorageOperation() {
        }

        boolean setAbortOperation(AbortRebalanceStorageOperation abortRebalanceOperation) {
            return this.abortRebalanceOperation.compareAndSet(null, abortRebalanceOperation);
        }

        @Nullable
        AbortRebalanceStorageOperation getAbortRebalanceOperation() {
            return this.abortRebalanceOperation.get();
        }

        CompletableFuture<Void> getStartRebalanceFuture() {
            return this.startRebalanceFuture;
        }

        @Override
        String inProcessErrorMessage(String storageInfo) {
            return "Storage in the process of starting a rebalance: [" + storageInfo + "]";
        }
    }

    static class DestroyStorageOperation
    extends StorageOperation {
        private final CompletableFuture<Void> destroyFuture = new CompletableFuture();
        private final AtomicReference<CreateStorageOperation> createStorageOperationReference = new AtomicReference();

        DestroyStorageOperation() {
        }

        boolean setCreationOperation(CreateStorageOperation createStorageOperation) {
            return this.createStorageOperationReference.compareAndSet(null, createStorageOperation);
        }

        @Nullable
        CreateStorageOperation getCreateStorageOperation() {
            return this.createStorageOperationReference.get();
        }

        CompletableFuture<Void> getDestroyFuture() {
            return this.destroyFuture;
        }

        @Override
        String inProcessErrorMessage(String storageInfo) {
            return "Storage is already in process of being destroyed: [" + storageInfo + "]";
        }
    }

    static class CreateStorageOperation
    extends StorageOperation {
        CreateStorageOperation() {
        }

        @Override
        String inProcessErrorMessage(String storageInfo) {
            return "Storage is in process of being created: [" + storageInfo + "]";
        }
    }
}

