/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class CatalogHashIndexDescriptor
extends CatalogIndexDescriptor {
    private final List<String> columns;

    public CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, List<String> columns) {
        this(id, name, tableId, unique, CatalogIndexStatus.REGISTERED, columns, CatalogManager.INITIAL_TIMESTAMP, false);
    }

    public CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<String> columns, boolean isCreatedWithTable) {
        this(id, name, tableId, unique, status, columns, CatalogManager.INITIAL_TIMESTAMP, isCreatedWithTable);
    }

    CatalogHashIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<String> columns, HybridTimestamp timestamp, boolean isCreatedWithTable) {
        super(CatalogIndexDescriptor.CatalogIndexDescriptorType.HASH, id, name, tableId, unique, status, timestamp, isCreatedWithTable);
        this.columns = List.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
    }

    public List<String> columns() {
        return this.columns;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_HASH_INDEX.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogHashIndexDescriptor.class, this, super.toString());
    }
}

