/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.treesitter.parser;

import org.treesitter.TSNode;

public enum HoconTokenType {
    QUOTE,
    STRING,
    PATH,
    NUMBER,
    COLON,
    EQUALS,
    BRACKET,
    COMMA,
    UNKNOWN,
    BOOL,
    SPACE;

    private static final String PATH_TYPE = "path";

    static HoconTokenType fromNode(TSNode node) {
        String nodeType;
        switch (nodeType = HoconTokenType.nodeType(node)) {
            case "\"": {
                return QUOTE;
            }
            case "path": {
                return PATH;
            }
            case "string": 
            case "unquoted_string": {
                return STRING;
            }
            case "{": 
            case "}": 
            case "[": 
            case "]": {
                return BRACKET;
            }
            case ",": {
                return COMMA;
            }
            case ":": {
                return COLON;
            }
            case "=": {
                return EQUALS;
            }
            case "number": {
                return NUMBER;
            }
            case "true": 
            case "false": {
                return BOOL;
            }
        }
        return UNKNOWN;
    }

    private static String nodeType(TSNode node) {
        TSNode parent = node;
        while (!parent.isNull()) {
            if (PATH_TYPE.equals(parent.getType())) {
                return PATH_TYPE;
            }
            parent = parent.getParent();
        }
        return node.getType();
    }
}

