/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.policy;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.CatalogPrefixParser;
import org.apache.polaris.service.catalog.api.PolarisCatalogPolicyApiService;
import org.apache.polaris.service.catalog.common.CatalogAdapter;
import org.apache.polaris.service.catalog.policy.PolicyCatalogAdapter;
import org.apache.polaris.service.events.CatalogPolicyServiceEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.GetApplicablePoliciesResponse;
import org.apache.polaris.service.types.LoadPolicyResponse;
import org.apache.polaris.service.types.UpdatePolicyRequest;

@Decorator
@Priority(value=1000)
public class CatalogPolicyEventServiceDelegator
implements PolarisCatalogPolicyApiService,
CatalogAdapter {
    @Inject
    @Delegate
    PolicyCatalogAdapter delegate;
    @Inject
    PolarisEventListener polarisEventListener;
    @Inject
    CatalogPrefixParser prefixParser;

    public Response createPolicy(String prefix, String namespace, CreatePolicyRequest createPolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeCreatePolicy(new CatalogPolicyServiceEvents.BeforeCreatePolicyEvent(catalogName, namespace, createPolicyRequest));
        Response resp = this.delegate.createPolicy(prefix, namespace, createPolicyRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterCreatePolicy(new CatalogPolicyServiceEvents.AfterCreatePolicyEvent(catalogName, namespace, (LoadPolicyResponse)resp.getEntity()));
        return resp;
    }

    public Response listPolicies(String prefix, String namespace, String pageToken, Integer pageSize, String policyType, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeListPolicies(new CatalogPolicyServiceEvents.BeforeListPoliciesEvent(catalogName, namespace, policyType));
        Response resp = this.delegate.listPolicies(prefix, namespace, pageToken, pageSize, policyType, realmContext, securityContext);
        this.polarisEventListener.onAfterListPolicies(new CatalogPolicyServiceEvents.AfterListPoliciesEvent(catalogName, namespace, policyType));
        return resp;
    }

    public Response loadPolicy(String prefix, String namespace, String policyName, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeLoadPolicy(new CatalogPolicyServiceEvents.BeforeLoadPolicyEvent(catalogName, namespace, policyName));
        Response resp = this.delegate.loadPolicy(prefix, namespace, policyName, realmContext, securityContext);
        this.polarisEventListener.onAfterLoadPolicy(new CatalogPolicyServiceEvents.AfterLoadPolicyEvent(catalogName, namespace, (LoadPolicyResponse)resp.getEntity()));
        return resp;
    }

    public Response updatePolicy(String prefix, String namespace, String policyName, UpdatePolicyRequest updatePolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeUpdatePolicy(new CatalogPolicyServiceEvents.BeforeUpdatePolicyEvent(catalogName, namespace, policyName, updatePolicyRequest));
        Response resp = this.delegate.updatePolicy(prefix, namespace, policyName, updatePolicyRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterUpdatePolicy(new CatalogPolicyServiceEvents.AfterUpdatePolicyEvent(catalogName, namespace, (LoadPolicyResponse)resp.getEntity()));
        return resp;
    }

    public Response dropPolicy(String prefix, String namespace, String policyName, Boolean detachAll, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeDropPolicy(new CatalogPolicyServiceEvents.BeforeDropPolicyEvent(catalogName, namespace, policyName, detachAll));
        Response resp = this.delegate.dropPolicy(prefix, namespace, policyName, detachAll, realmContext, securityContext);
        this.polarisEventListener.onAfterDropPolicy(new CatalogPolicyServiceEvents.AfterDropPolicyEvent(catalogName, namespace, policyName, detachAll));
        return resp;
    }

    public Response attachPolicy(String prefix, String namespace, String policyName, AttachPolicyRequest attachPolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeAttachPolicy(new CatalogPolicyServiceEvents.BeforeAttachPolicyEvent(catalogName, namespace, policyName, attachPolicyRequest));
        Response resp = this.delegate.attachPolicy(prefix, namespace, policyName, attachPolicyRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterAttachPolicy(new CatalogPolicyServiceEvents.AfterAttachPolicyEvent(catalogName, namespace, policyName, attachPolicyRequest));
        return resp;
    }

    public Response detachPolicy(String prefix, String namespace, String policyName, DetachPolicyRequest detachPolicyRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeDetachPolicy(new CatalogPolicyServiceEvents.BeforeDetachPolicyEvent(catalogName, namespace, policyName, detachPolicyRequest));
        Response resp = this.delegate.detachPolicy(prefix, namespace, policyName, detachPolicyRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterDetachPolicy(new CatalogPolicyServiceEvents.AfterDetachPolicyEvent(catalogName, namespace, policyName, detachPolicyRequest));
        return resp;
    }

    public Response getApplicablePolicies(String prefix, String pageToken, Integer pageSize, String namespace, String targetName, String policyType, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeGetApplicablePolicies(new CatalogPolicyServiceEvents.BeforeGetApplicablePoliciesEvent(catalogName, namespace, targetName, policyType));
        Response resp = this.delegate.getApplicablePolicies(prefix, pageToken, pageSize, namespace, targetName, policyType, realmContext, securityContext);
        this.polarisEventListener.onAfterGetApplicablePolicies(new CatalogPolicyServiceEvents.AfterGetApplicablePoliciesEvent(catalogName, namespace, targetName, policyType, (GetApplicablePoliciesResponse)resp.getEntity()));
        return resp;
    }
}

