/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime;

import io.smallrye.faulttolerance.BeforeRetryHandlerProvider;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;

@Dependent
@Alternative
@Priority(value=1)
public class QuarkusBeforeRetryHandlerProvider
implements BeforeRetryHandlerProvider {
    @Inject
    @Any
    Instance<BeforeRetryHandler> instance;

    public BeforeRetryHandler get(final FaultToleranceOperation operation) {
        if (operation.hasBeforeRetry()) {
            return new BeforeRetryHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(ExecutionContext context) {
                    Class clazz = operation.getBeforeRetry().value();
                    BeforeRetryHandler handler = (BeforeRetryHandler)QuarkusBeforeRetryHandlerProvider.this.instance.select(clazz, new Annotation[0]).get();
                    try {
                        handler.handle(context);
                    }
                    finally {
                        QuarkusBeforeRetryHandlerProvider.this.instance.destroy((Object)handler);
                    }
                }
            };
        }
        return null;
    }
}

