/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import org.apache.iceberg.variants.SerializedMetadata;

public interface VariantMetadata {
    public int id(String var1);

    public String get(int var1);

    public int dictionarySize();

    public int sizeInBytes();

    public int writeTo(ByteBuffer var1, int var2);

    public static VariantMetadata from(ByteBuffer buffer) {
        return SerializedMetadata.from(buffer);
    }

    public static VariantMetadata empty() {
        return SerializedMetadata.EMPTY_V1_METADATA;
    }

    public static String asString(VariantMetadata metadata) {
        StringBuilder builder = new StringBuilder();
        builder.append("VariantMetadata(dict={");
        for (int i = 0; i < metadata.dictionarySize(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(i).append(" => ").append(metadata.get(i));
        }
        builder.append("})");
        return builder.toString();
    }
}

