/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.apiimpl;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.Guard;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.apiimpl.AsyncInvocation;
import io.smallrye.faulttolerance.apiimpl.BasicMeteredOperationImpl;
import io.smallrye.faulttolerance.apiimpl.BuilderEagerDependencies;
import io.smallrye.faulttolerance.apiimpl.BuilderLazyDependencies;
import io.smallrye.faulttolerance.apiimpl.EventHandlers;
import io.smallrye.faulttolerance.apiimpl.GuardCommon;
import io.smallrye.faulttolerance.apiimpl.LazyGuard;
import io.smallrye.faulttolerance.basicconfig.BasicFaultToleranceOperation;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.async.RememberEventLoop;
import io.smallrye.faulttolerance.core.async.SyncAsyncSplit;
import io.smallrye.faulttolerance.core.async.ThreadOffload;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.metrics.DelegatingMetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.ConstantBackOff;
import io.smallrye.faulttolerance.core.retry.CustomBackOff;
import io.smallrye.faulttolerance.core.retry.ExponentialBackOff;
import io.smallrye.faulttolerance.core.retry.FibonacciBackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.util.Durations;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class GuardImpl
implements Guard {
    final FaultToleranceStrategy<?> strategy;
    final EventHandlers eventHandlers;

    GuardImpl(FaultToleranceStrategy<?> strategy, EventHandlers eventHandlers) {
        this.strategy = strategy;
        this.eventHandlers = eventHandlers;
    }

    public <T> T call(Callable<T> action, Class<T> type) throws Exception {
        return this.guard(action, type);
    }

    public <T> T call(Callable<T> action, TypeLiteral<T> type) throws Exception {
        return this.guard(action, type.getType());
    }

    public <T> T get(Supplier<T> action, Class<T> type) {
        try {
            return (T)this.guard(action::get, type);
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow((Throwable)e);
        }
    }

    public <T> T get(Supplier<T> action, TypeLiteral<T> type) {
        try {
            return (T)this.guard(action::get, type.getType());
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow((Throwable)e);
        }
    }

    private <V, T> T guard(Callable<T> action, Type valueType) throws Exception {
        FaultToleranceStrategy<?> castStrategy = this.strategy;
        AsyncSupport asyncSupport = GuardCommon.asyncSupport(valueType);
        AsyncInvocation asyncInvocation = GuardCommon.asyncInvocation(action, asyncSupport);
        return GuardCommon.guard(action, castStrategy, asyncInvocation, this.eventHandlers, null);
    }

    public <V, T> T guard(Callable<T> action, AsyncInvocation<V, T> asyncInvocation, Consumer<FaultToleranceContext<?>> contextModifier) throws Exception {
        FaultToleranceStrategy<?> castStrategy = this.strategy;
        return GuardCommon.guard(action, castStrategy, asyncInvocation, this.eventHandlers, contextModifier);
    }

    public static class BuilderImpl
    implements Guard.Builder {
        private final BuilderEagerDependencies eagerDependencies;
        private final Supplier<BuilderLazyDependencies> lazyDependencies;
        private String description;
        private boolean descriptionSet;
        private BulkheadBuilderImpl bulkheadBuilder;
        private CircuitBreakerBuilderImpl circuitBreakerBuilder;
        private RateLimitBuilderImpl rateLimitBuilder;
        private RetryBuilderImpl retryBuilder;
        private TimeoutBuilderImpl timeoutBuilder;
        private boolean offloadToAnotherThread;
        private Executor offloadExecutor;

        public BuilderImpl(BuilderEagerDependencies eagerDependencies, Supplier<BuilderLazyDependencies> lazyDependencies) {
            this.eagerDependencies = eagerDependencies;
            this.lazyDependencies = lazyDependencies;
            this.description = UUID.randomUUID().toString();
            this.descriptionSet = false;
        }

        public Guard.Builder withDescription(String value) {
            this.description = (String)Preconditions.checkNotNull((Object)value, (String)"Description must be set");
            this.descriptionSet = true;
            return this;
        }

        public Guard.Builder.BulkheadBuilder withBulkhead() {
            return new BulkheadBuilderImpl(this);
        }

        public Guard.Builder.CircuitBreakerBuilder withCircuitBreaker() {
            return new CircuitBreakerBuilderImpl(this);
        }

        public Guard.Builder.RateLimitBuilder withRateLimit() {
            return new RateLimitBuilderImpl(this);
        }

        public Guard.Builder.RetryBuilder withRetry() {
            return new RetryBuilderImpl(this);
        }

        public Guard.Builder.TimeoutBuilder withTimeout() {
            return new TimeoutBuilderImpl(this);
        }

        public Guard.Builder withThreadOffload(boolean value) {
            this.offloadToAnotherThread = value;
            return this;
        }

        public Guard.Builder withThreadOffloadExecutor(Executor executor) {
            this.offloadExecutor = (Executor)Preconditions.checkNotNull((Object)executor, (String)"Thread offload executor must be set");
            return this;
        }

        public Guard build() {
            this.eagerInitialization();
            return new LazyGuard(id -> new GuardImpl(this.buildStrategy((String)id, this.lazyDependencies.get()), this.buildEventHandlers()));
        }

        final void eagerInitialization() {
            if (this.circuitBreakerBuilder != null && this.circuitBreakerBuilder.name != null) {
                this.eagerDependencies.cbMaintenance().registerName(this.circuitBreakerBuilder.name);
            }
        }

        final EventHandlers buildEventHandlers() {
            Consumer<CircuitBreakerEvents.StateTransition> cbMaintenanceEventHandler = null;
            if (this.circuitBreakerBuilder != null && this.circuitBreakerBuilder.name != null) {
                cbMaintenanceEventHandler = this.eagerDependencies.cbMaintenance().stateTransitionEventHandler(this.circuitBreakerBuilder.name);
            }
            return new EventHandlers(this.bulkheadBuilder != null ? this.bulkheadBuilder.onAccepted : null, this.bulkheadBuilder != null ? this.bulkheadBuilder.onRejected : null, this.bulkheadBuilder != null ? this.bulkheadBuilder.onFinished : null, cbMaintenanceEventHandler, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onStateChange : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onSuccess : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onFailure : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onPrevented : null, this.rateLimitBuilder != null ? this.rateLimitBuilder.onPermitted : null, this.rateLimitBuilder != null ? this.rateLimitBuilder.onRejected : null, this.retryBuilder != null ? this.retryBuilder.onRetry : null, this.retryBuilder != null ? this.retryBuilder.onSuccess : null, this.retryBuilder != null ? this.retryBuilder.onFailure : null, this.timeoutBuilder != null ? this.timeoutBuilder.onTimeout : null, this.timeoutBuilder != null ? this.timeoutBuilder.onFinished : null);
        }

        final <V> FaultToleranceStrategy<V> buildStrategy(String id, BuilderLazyDependencies lazyDependencies) {
            BasicFaultToleranceOperation op = new BasicFaultToleranceOperation(id, this.bulkheadBuilder, this.circuitBreakerBuilder, this.rateLimitBuilder, this.retryBuilder, this.timeoutBuilder, this.retryBuilder != null ? this.retryBuilder.exponentialBackoffBuilder : null, this.retryBuilder != null ? this.retryBuilder.fibonacciBackoffBuilder : null);
            op.validate();
            Invocation result = Invocation.invocation();
            Executor executor = this.offloadExecutor != null ? this.offloadExecutor : lazyDependencies.asyncExecutor();
            result = new SyncAsyncSplit((FaultToleranceStrategy)new ThreadOffload((FaultToleranceStrategy)result, executor, this.offloadToAnotherThread), (FaultToleranceStrategy)result);
            if (lazyDependencies.ftEnabled() && op.hasBulkhead()) {
                result = new io.smallrye.faulttolerance.core.bulkhead.Bulkhead((FaultToleranceStrategy)result, this.description, op.getBulkhead().value(), op.getBulkhead().waitingTaskQueue(), this.bulkheadBuilder.syncQueueingEnabled);
            }
            if (lazyDependencies.ftEnabled() && op.hasTimeout()) {
                result = new io.smallrye.faulttolerance.core.timeout.Timeout((FaultToleranceStrategy)result, this.description, Durations.timeInMillis((long)op.getTimeout().value(), (ChronoUnit)op.getTimeout().unit()), lazyDependencies.timer());
            }
            if (lazyDependencies.ftEnabled() && op.hasRateLimit()) {
                result = new io.smallrye.faulttolerance.core.rate.limit.RateLimit((FaultToleranceStrategy)result, this.description, op.getRateLimit().value(), Durations.timeInMillis((long)op.getRateLimit().window(), (ChronoUnit)op.getRateLimit().windowUnit()), Durations.timeInMillis((long)op.getRateLimit().minSpacing(), (ChronoUnit)op.getRateLimit().minSpacingUnit()), op.getRateLimit().type(), (Stopwatch)SystemStopwatch.INSTANCE);
            }
            if (lazyDependencies.ftEnabled() && op.hasCircuitBreaker()) {
                result = new CircuitBreaker((FaultToleranceStrategy)result, this.description, GuardCommon.createExceptionDecision(op.getCircuitBreaker().skipOn(), op.getCircuitBreaker().failOn(), this.circuitBreakerBuilder.whenPredicate), Durations.timeInMillis((long)op.getCircuitBreaker().delay(), (ChronoUnit)op.getCircuitBreaker().delayUnit()), op.getCircuitBreaker().requestVolumeThreshold(), op.getCircuitBreaker().failureRatio(), op.getCircuitBreaker().successThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, lazyDependencies.timer());
                if (this.circuitBreakerBuilder.name != null) {
                    CircuitBreaker circuitBreaker = (CircuitBreaker)result;
                    this.eagerDependencies.cbMaintenance().register(this.circuitBreakerBuilder.name, circuitBreaker);
                }
            }
            if (lazyDependencies.ftEnabled() && op.hasRetry()) {
                Supplier<BackOff> backoff = BuilderImpl.prepareRetryBackoff(op, this.retryBuilder);
                Consumer<Throwable> beforeRetryAction = this.retryBuilder.beforeRetry;
                result = new io.smallrye.faulttolerance.core.retry.Retry((FaultToleranceStrategy)result, this.description, GuardCommon.createResultDecision(this.retryBuilder.whenResultPredicate), GuardCommon.createExceptionDecision(op.getRetry().abortOn(), op.getRetry().retryOn(), this.retryBuilder.whenExceptionPredicate), (long)op.getRetry().maxRetries(), Durations.timeInMillis((long)op.getRetry().maxDuration(), (ChronoUnit)op.getRetry().durationUnit()), () -> new ThreadSleepDelay((BackOff)backoff.get()), () -> new TimerDelay((BackOff)backoff.get(), lazyDependencies.timer()), (Stopwatch)SystemStopwatch.INSTANCE, beforeRetryAction != null ? ctx -> beforeRetryAction.accept(ctx.failure) : null);
            }
            result = new Fallback((FaultToleranceStrategy)result, this.description, FallbackFunction.ignore(), ExceptionDecision.IGNORE);
            MetricsProvider metricsProvider = lazyDependencies.metricsProvider();
            if (metricsProvider.isEnabled()) {
                MeteredOperation defaultOperation = this.buildMeteredOperation();
                result = new DelegatingMetricsCollector((FaultToleranceStrategy)result, metricsProvider, defaultOperation);
            }
            result = new SyncAsyncSplit((FaultToleranceStrategy)new RememberEventLoop((FaultToleranceStrategy)result, lazyDependencies.eventLoop(), this.offloadToAnotherThread), (FaultToleranceStrategy)result);
            return result;
        }

        private MeteredOperation buildMeteredOperation() {
            return new BasicMeteredOperationImpl(this.descriptionSet, this.description, true, this.bulkheadBuilder != null, this.circuitBreakerBuilder != null, false, this.rateLimitBuilder != null, this.retryBuilder != null, this.timeoutBuilder != null);
        }

        private static Supplier<BackOff> prepareRetryBackoff(BasicFaultToleranceOperation op, RetryBuilderImpl retryBuilder) {
            Jitter jitter;
            long delayMs = Durations.timeInMillis((long)op.getRetry().delay(), (ChronoUnit)op.getRetry().delayUnit());
            long jitterMs = Durations.timeInMillis((long)op.getRetry().jitter(), (ChronoUnit)op.getRetry().jitterDelayUnit());
            Object object = jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            if (op.hasExponentialBackoff()) {
                int factor = op.getExponentialBackoff().factor();
                long maxDelayMs = Durations.timeInMillis((long)op.getExponentialBackoff().maxDelay(), (ChronoUnit)op.getExponentialBackoff().maxDelayUnit());
                return () -> new ExponentialBackOff(delayMs, factor, jitter, maxDelayMs);
            }
            if (op.hasFibonacciBackoff()) {
                long maxDelayMs = Durations.timeInMillis((long)op.getFibonacciBackoff().maxDelay(), (ChronoUnit)op.getFibonacciBackoff().maxDelayUnit());
                return () -> new FibonacciBackOff(delayMs, jitter, maxDelayMs);
            }
            if (retryBuilder.customBackoffBuilder != null) {
                Supplier<CustomBackoffStrategy> strategy = retryBuilder.customBackoffBuilder.strategy;
                return () -> {
                    CustomBackoffStrategy instance = (CustomBackoffStrategy)strategy.get();
                    instance.init(delayMs);
                    return new CustomBackOff(arg_0 -> ((CustomBackoffStrategy)instance).nextDelayInMillis(arg_0));
                };
            }
            return () -> new ConstantBackOff(delayMs, jitter);
        }

        static class BulkheadBuilderImpl
        implements Guard.Builder.BulkheadBuilder,
        Supplier<Bulkhead> {
            private final BuilderImpl parent;
            private int limit = 10;
            private int queueSize = 10;
            private boolean syncQueueingEnabled;
            private Runnable onAccepted;
            private Runnable onRejected;
            private Runnable onFinished;

            BulkheadBuilderImpl(BuilderImpl parent) {
                this.parent = parent;
            }

            public Guard.Builder.BulkheadBuilder limit(int value) {
                this.limit = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Limit must be >= 1");
                return this;
            }

            public Guard.Builder.BulkheadBuilder queueSize(int value) {
                this.queueSize = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Queue size must be >= 1");
                return this;
            }

            public Guard.Builder.BulkheadBuilder enableSynchronousQueueing() {
                this.syncQueueingEnabled = true;
                return this;
            }

            public Guard.Builder.BulkheadBuilder onAccepted(Runnable callback) {
                this.onAccepted = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Accepted callback must be set");
                return this;
            }

            public Guard.Builder.BulkheadBuilder onRejected(Runnable callback) {
                this.onRejected = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Rejected callback must be set");
                return this;
            }

            public Guard.Builder.BulkheadBuilder onFinished(Runnable callback) {
                this.onFinished = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Finished callback must be set");
                return this;
            }

            public Guard.Builder done() {
                try {
                    Math.addExact(this.limit, this.queueSize);
                }
                catch (ArithmeticException e) {
                    throw new IllegalStateException("Bulkhead capacity overflow, " + this.limit + " + " + this.queueSize + " = " + (this.limit + this.queueSize));
                }
                this.parent.bulkheadBuilder = this;
                return this.parent;
            }

            @Override
            public Bulkhead get() {
                return new Bulkhead(){

                    public int value() {
                        return limit;
                    }

                    public int waitingTaskQueue() {
                        return queueSize;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Bulkhead.class;
                    }
                };
            }
        }

        static class CircuitBreakerBuilderImpl
        implements Guard.Builder.CircuitBreakerBuilder,
        Supplier<org.eclipse.microprofile.faulttolerance.CircuitBreaker> {
            private final BuilderImpl parent;
            private Class<? extends Throwable>[] failOn = new Class[]{Throwable.class};
            private Class<? extends Throwable>[] skipOn = new Class[0];
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenPredicate;
            private long delay = 5000L;
            private ChronoUnit delayUnit = ChronoUnit.MILLIS;
            private int requestVolumeThreshold = 20;
            private double failureRatio = 0.5;
            private int successThreshold = 1;
            private String name;
            private Consumer<CircuitBreakerState> onStateChange;
            private Runnable onSuccess;
            private Runnable onFailure;
            private Runnable onPrevented;

            CircuitBreakerBuilderImpl(BuilderImpl parent) {
                this.parent = parent;
            }

            public Guard.Builder.CircuitBreakerBuilder failOn(Collection<Class<? extends Throwable>> value) {
                this.failOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions considered failure must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder failOn(Class<? extends Throwable> value) {
                this.failOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception considered failure must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder skipOn(Collection<Class<? extends Throwable>> value) {
                this.skipOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions considered success must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder skipOn(Class<? extends Throwable> value) {
                this.skipOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception considered success must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder when(Predicate<Throwable> value) {
                this.whenPredicate = (Predicate)Preconditions.checkNotNull(value, (String)"Exception predicate must be set");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder delay(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Delay must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Delay unit must be set");
                this.delay = value;
                this.delayUnit = unit;
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder requestVolumeThreshold(int value) {
                this.requestVolumeThreshold = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Request volume threshold must be >= 1");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder failureRatio(double value) {
                this.failureRatio = Preconditions.check((double)value, (value >= 0.0 && value <= 1.0 ? 1 : 0) != 0, (String)"Failure ratio must be >= 0 and <= 1");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder successThreshold(int value) {
                this.successThreshold = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Success threshold must be >= 1");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder name(String value) {
                this.name = (String)Preconditions.checkNotNull((Object)value, (String)"Circuit breaker name must be set");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder onStateChange(Consumer<CircuitBreakerState> callback) {
                this.onStateChange = (Consumer)Preconditions.checkNotNull(callback, (String)"On state change callback must be set");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder onSuccess(Runnable callback) {
                this.onSuccess = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"On success callback must be set");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder onFailure(Runnable callback) {
                this.onFailure = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"On failure callback must be set");
                return this;
            }

            public Guard.Builder.CircuitBreakerBuilder onPrevented(Runnable callback) {
                this.onPrevented = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"On prevented callback must be set");
                return this;
            }

            public Guard.Builder done() {
                if (this.whenPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The when() method may not be combined with failOn() / skipOn()");
                }
                this.parent.circuitBreakerBuilder = this;
                return this.parent;
            }

            @Override
            public org.eclipse.microprofile.faulttolerance.CircuitBreaker get() {
                return new org.eclipse.microprofile.faulttolerance.CircuitBreaker(){

                    public Class<? extends Throwable>[] failOn() {
                        return failOn;
                    }

                    public Class<? extends Throwable>[] skipOn() {
                        return skipOn;
                    }

                    public long delay() {
                        return delay;
                    }

                    public ChronoUnit delayUnit() {
                        return delayUnit;
                    }

                    public int requestVolumeThreshold() {
                        return requestVolumeThreshold;
                    }

                    public double failureRatio() {
                        return failureRatio;
                    }

                    public int successThreshold() {
                        return successThreshold;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return org.eclipse.microprofile.faulttolerance.CircuitBreaker.class;
                    }
                };
            }
        }

        static class RateLimitBuilderImpl
        implements Guard.Builder.RateLimitBuilder,
        Supplier<RateLimit> {
            private final BuilderImpl parent;
            private int maxInvocations = 100;
            private long timeWindow = 1L;
            private ChronoUnit timeWindowUnit = ChronoUnit.SECONDS;
            private long minSpacing = 0L;
            private ChronoUnit minSpacingUnit = ChronoUnit.SECONDS;
            private RateLimitType type = RateLimitType.FIXED;
            private Runnable onPermitted;
            private Runnable onRejected;

            RateLimitBuilderImpl(BuilderImpl parent) {
                this.parent = parent;
            }

            public Guard.Builder.RateLimitBuilder limit(int value) {
                this.maxInvocations = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Rate limit must be >= 1");
                return this;
            }

            public Guard.Builder.RateLimitBuilder window(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 1L ? 1 : 0) != 0, (String)"Time window length must be >= 1");
                Preconditions.checkNotNull((Object)unit, (String)"Time window length unit must be set");
                this.timeWindow = value;
                this.timeWindowUnit = unit;
                return this;
            }

            public Guard.Builder.RateLimitBuilder minSpacing(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Min spacing must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Min spacing unit must be set");
                this.minSpacing = value;
                this.minSpacingUnit = unit;
                return this;
            }

            public Guard.Builder.RateLimitBuilder type(RateLimitType value) {
                this.type = (RateLimitType)Preconditions.checkNotNull((Object)value, (String)"Time window type must be set");
                return this;
            }

            public Guard.Builder.RateLimitBuilder onPermitted(Runnable callback) {
                this.onPermitted = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Permitted callback must be set");
                return this;
            }

            public Guard.Builder.RateLimitBuilder onRejected(Runnable callback) {
                this.onRejected = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Rejected callback must be set");
                return this;
            }

            public Guard.Builder done() {
                this.parent.rateLimitBuilder = this;
                return this.parent;
            }

            @Override
            public RateLimit get() {
                return new RateLimit(){

                    public int value() {
                        return maxInvocations;
                    }

                    public long window() {
                        return timeWindow;
                    }

                    public ChronoUnit windowUnit() {
                        return timeWindowUnit;
                    }

                    public long minSpacing() {
                        return minSpacing;
                    }

                    public ChronoUnit minSpacingUnit() {
                        return minSpacingUnit;
                    }

                    public RateLimitType type() {
                        return type;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return RateLimit.class;
                    }
                };
            }
        }

        static class RetryBuilderImpl
        implements Guard.Builder.RetryBuilder,
        Supplier<Retry> {
            private final BuilderImpl parent;
            private int maxRetries = 3;
            private long delay = 0L;
            private ChronoUnit delayUnit = ChronoUnit.MILLIS;
            private long maxDuration = 180000L;
            private ChronoUnit maxDurationUnit = ChronoUnit.MILLIS;
            private long jitter = 200L;
            private ChronoUnit jitterUnit = ChronoUnit.MILLIS;
            private Class<? extends Throwable>[] retryOn = new Class[]{Exception.class};
            private Class<? extends Throwable>[] abortOn = new Class[0];
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenExceptionPredicate;
            private Predicate<Object> whenResultPredicate;
            private Consumer<Throwable> beforeRetry;
            private ExponentialBackoffBuilderImpl exponentialBackoffBuilder;
            private FibonacciBackoffBuilderImpl fibonacciBackoffBuilder;
            private CustomBackoffBuilderImpl customBackoffBuilder;
            private Runnable onRetry;
            private Runnable onSuccess;
            private Runnable onFailure;

            RetryBuilderImpl(BuilderImpl parent) {
                this.parent = parent;
            }

            public Guard.Builder.RetryBuilder maxRetries(int value) {
                this.maxRetries = Preconditions.check((int)value, (value >= -1 ? 1 : 0) != 0, (String)"Max retries must be >= -1");
                return this;
            }

            public Guard.Builder.RetryBuilder delay(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Delay must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Delay unit must be set");
                this.delay = value;
                this.delayUnit = unit;
                return this;
            }

            public Guard.Builder.RetryBuilder maxDuration(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Max duration must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Max duration unit must be set");
                this.maxDuration = value;
                this.maxDurationUnit = unit;
                return this;
            }

            public Guard.Builder.RetryBuilder jitter(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Jitter must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Jitter unit must be set");
                this.jitter = value;
                this.jitterUnit = unit;
                return this;
            }

            public Guard.Builder.RetryBuilder retryOn(Collection<Class<? extends Throwable>> value) {
                this.retryOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions to retry on must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.RetryBuilder retryOn(Class<? extends Throwable> value) {
                this.retryOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception to retry on must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.RetryBuilder abortOn(Collection<Class<? extends Throwable>> value) {
                this.abortOn = ((Collection)Preconditions.checkNotNull(value, (String)"Exceptions to abort retrying on must be set")).toArray(new Class[0]);
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.RetryBuilder abortOn(Class<? extends Throwable> value) {
                this.abortOn = new Class[]{(Class)Preconditions.checkNotNull(value, (String)"Exception to abort retrying on must be set")};
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public Guard.Builder.RetryBuilder whenResult(Predicate<Object> value) {
                this.whenResultPredicate = (Predicate)Preconditions.checkNotNull(value, (String)"Result predicate must be set");
                return this;
            }

            public Guard.Builder.RetryBuilder whenException(Predicate<Throwable> value) {
                this.whenExceptionPredicate = (Predicate)Preconditions.checkNotNull(value, (String)"Exception predicate must be set");
                return this;
            }

            public Guard.Builder.RetryBuilder beforeRetry(Runnable value) {
                Preconditions.checkNotNull((Object)value, (String)"Before retry handler must be set");
                this.beforeRetry = ignored -> value.run();
                return this;
            }

            public Guard.Builder.RetryBuilder beforeRetry(Consumer<Throwable> value) {
                this.beforeRetry = (Consumer)Preconditions.checkNotNull(value, (String)"Before retry handler must be set");
                return this;
            }

            public Guard.Builder.RetryBuilder.ExponentialBackoffBuilder withExponentialBackoff() {
                return new ExponentialBackoffBuilderImpl(this);
            }

            public Guard.Builder.RetryBuilder.FibonacciBackoffBuilder withFibonacciBackoff() {
                return new FibonacciBackoffBuilderImpl(this);
            }

            public Guard.Builder.RetryBuilder.CustomBackoffBuilder withCustomBackoff() {
                return new CustomBackoffBuilderImpl(this);
            }

            public Guard.Builder.RetryBuilder onRetry(Runnable callback) {
                this.onRetry = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Retry callback must be set");
                return this;
            }

            public Guard.Builder.RetryBuilder onSuccess(Runnable callback) {
                this.onSuccess = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Success callback must be set");
                return this;
            }

            public Guard.Builder.RetryBuilder onFailure(Runnable callback) {
                this.onFailure = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Failure callback must be set");
                return this;
            }

            public Guard.Builder done() {
                if (this.whenExceptionPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The whenException() method may not be combined with retryOn()/abortOn()");
                }
                int backoffStrategies = 0;
                if (this.exponentialBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.fibonacciBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.customBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (backoffStrategies > 1) {
                    throw new IllegalStateException("Only one backoff strategy may be set for retry");
                }
                this.parent.retryBuilder = this;
                return this.parent;
            }

            @Override
            public Retry get() {
                return new Retry(){

                    public int maxRetries() {
                        return maxRetries;
                    }

                    public long delay() {
                        return delay;
                    }

                    public ChronoUnit delayUnit() {
                        return delayUnit;
                    }

                    public long maxDuration() {
                        return maxDuration;
                    }

                    public ChronoUnit durationUnit() {
                        return maxDurationUnit;
                    }

                    public long jitter() {
                        return jitter;
                    }

                    public ChronoUnit jitterDelayUnit() {
                        return jitterUnit;
                    }

                    public Class<? extends Throwable>[] retryOn() {
                        return retryOn;
                    }

                    public Class<? extends Throwable>[] abortOn() {
                        return abortOn;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Retry.class;
                    }
                };
            }

            static class ExponentialBackoffBuilderImpl
            implements Guard.Builder.RetryBuilder.ExponentialBackoffBuilder,
            Supplier<ExponentialBackoff> {
                private final RetryBuilderImpl parent;
                private int factor = 2;
                private long maxDelay = 60000L;
                private ChronoUnit maxDelayUnit = ChronoUnit.MILLIS;

                ExponentialBackoffBuilderImpl(RetryBuilderImpl parent) {
                    this.parent = parent;
                }

                public Guard.Builder.RetryBuilder.ExponentialBackoffBuilder factor(int value) {
                    this.factor = Preconditions.check((int)value, (value >= 1 ? 1 : 0) != 0, (String)"Factor must be >= 1");
                    return this;
                }

                public Guard.Builder.RetryBuilder.ExponentialBackoffBuilder maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Max delay must be >= 0");
                    Preconditions.checkNotNull((Object)unit, (String)"Max delay unit must be set");
                    this.maxDelay = value;
                    this.maxDelayUnit = unit;
                    return this;
                }

                public Guard.Builder.RetryBuilder done() {
                    this.parent.exponentialBackoffBuilder = this;
                    return this.parent;
                }

                @Override
                public ExponentialBackoff get() {
                    return new ExponentialBackoff(){

                        public int factor() {
                            return factor;
                        }

                        public long maxDelay() {
                            return maxDelay;
                        }

                        public ChronoUnit maxDelayUnit() {
                            return maxDelayUnit;
                        }

                        public Class<? extends Annotation> annotationType() {
                            return ExponentialBackoff.class;
                        }
                    };
                }
            }

            static class FibonacciBackoffBuilderImpl
            implements Guard.Builder.RetryBuilder.FibonacciBackoffBuilder,
            Supplier<FibonacciBackoff> {
                private final RetryBuilderImpl parent;
                private long maxDelay = 60000L;
                private ChronoUnit maxDelayUnit = ChronoUnit.MILLIS;

                FibonacciBackoffBuilderImpl(RetryBuilderImpl parent) {
                    this.parent = parent;
                }

                public Guard.Builder.RetryBuilder.FibonacciBackoffBuilder maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Max delay must be >= 0");
                    Preconditions.checkNotNull((Object)unit, (String)"Max delay unit must be set");
                    this.maxDelay = value;
                    this.maxDelayUnit = unit;
                    return this;
                }

                public Guard.Builder.RetryBuilder done() {
                    this.parent.fibonacciBackoffBuilder = this;
                    return this.parent;
                }

                @Override
                public FibonacciBackoff get() {
                    return new FibonacciBackoff(){

                        public long maxDelay() {
                            return maxDelay;
                        }

                        public ChronoUnit maxDelayUnit() {
                            return maxDelayUnit;
                        }

                        public Class<? extends Annotation> annotationType() {
                            return FibonacciBackoff.class;
                        }
                    };
                }
            }

            static class CustomBackoffBuilderImpl
            implements Guard.Builder.RetryBuilder.CustomBackoffBuilder {
                private final RetryBuilderImpl parent;
                private Supplier<CustomBackoffStrategy> strategy;

                CustomBackoffBuilderImpl(RetryBuilderImpl parent) {
                    this.parent = parent;
                }

                public Guard.Builder.RetryBuilder.CustomBackoffBuilder strategy(Supplier<CustomBackoffStrategy> value) {
                    this.strategy = (Supplier)Preconditions.checkNotNull(value, (String)"Custom backoff strategy must be set");
                    return this;
                }

                public Guard.Builder.RetryBuilder done() {
                    Preconditions.checkNotNull(this.strategy, (String)"Custom backoff strategy must be set");
                    this.parent.customBackoffBuilder = this;
                    return this.parent;
                }
            }
        }

        static class TimeoutBuilderImpl
        implements Guard.Builder.TimeoutBuilder,
        Supplier<Timeout> {
            private final BuilderImpl parent;
            private long value = 1000L;
            private ChronoUnit unit = ChronoUnit.MILLIS;
            private Runnable onTimeout;
            private Runnable onFinished;

            TimeoutBuilderImpl(BuilderImpl parent) {
                this.parent = parent;
            }

            public Guard.Builder.TimeoutBuilder duration(long value, ChronoUnit unit) {
                Preconditions.check((long)value, (value >= 0L ? 1 : 0) != 0, (String)"Timeout duration must be >= 0");
                Preconditions.checkNotNull((Object)unit, (String)"Timeout duration unit must be set");
                this.value = value;
                this.unit = unit;
                return this;
            }

            public Guard.Builder.TimeoutBuilder onTimeout(Runnable callback) {
                this.onTimeout = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Timeout callback must be set");
                return this;
            }

            public Guard.Builder.TimeoutBuilder onFinished(Runnable callback) {
                this.onFinished = (Runnable)Preconditions.checkNotNull((Object)callback, (String)"Finished callback must be set");
                return this;
            }

            public Guard.Builder done() {
                this.parent.timeoutBuilder = this;
                return this.parent;
            }

            @Override
            public Timeout get() {
                return new Timeout(){

                    public long value() {
                        return value;
                    }

                    public ChronoUnit unit() {
                        return unit;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Timeout.class;
                    }
                };
            }
        }
    }
}

