/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import java.util.Map;
import java.util.Objects;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.Timestamp;

public class ReconfigurationStatus {
    private final Timestamp startTime;
    private final Timestamp endTime;
    private final Map<PropertyChange, Throwable> changes;
    private final Daemon daemon;

    private static String quote(String value) {
        return value == null ? "<default>" : "\"" + value + "\"";
    }

    static String propertyString(String property, String newValue, String oldValue) {
        Objects.requireNonNull(property, "property == null");
        return property + " from " + ReconfigurationStatus.quote(oldValue) + " to " + ReconfigurationStatus.quote(newValue);
    }

    ReconfigurationStatus(Timestamp startTime, Timestamp endTime, Map<PropertyChange, Throwable> changes, Daemon daemon) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.changes = changes;
        this.daemon = daemon;
    }

    public boolean started() {
        return this.getStartTime() != null;
    }

    public boolean ended() {
        return this.getEndTime() != null;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public Map<PropertyChange, Throwable> getChanges() {
        return this.changes;
    }

    Daemon getDaemon() {
        return this.daemon;
    }

    public static class PropertyChange {
        private final String property;
        private final String newValue;
        private final String oldValue;

        public PropertyChange(String property, String newValue, String oldValue) {
            this.property = property;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public String getProperty() {
            return this.property;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public int hashCode() {
            return this.property.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PropertyChange)) {
                return false;
            }
            PropertyChange that = (PropertyChange)obj;
            return Objects.equals(this.property, that.property) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
        }

        public String toString() {
            return ReconfigurationStatus.propertyString(this.getProperty(), this.getNewValue(), this.getOldValue());
        }
    }
}

