/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCacheMetrics;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceCacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCacheBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCachePolicy;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DeviceSchemaCache {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(DeviceSchemaCache.class);
    private final IDualKeyCache<String, PartialPath, DeviceCacheEntry> dualKeyCache;
    private final Map<String, String> databasePool = new ConcurrentHashMap<String, String>();
    private final ReentrantLock lock = new ReentrantLock(false);

    DeviceSchemaCache() {
        this.dualKeyCache = new DualKeyCacheBuilder().cacheEvictionPolicy(DualKeyCachePolicy.valueOf(config.getDataNodeSchemaCacheEvictionPolicy())).memoryCapacity(config.getAllocateMemoryForSchemaCache()).firstKeySizeComputer(segment -> (int)RamUsageEstimator.sizeOf((String)segment)).secondKeySizeComputer(PartialPath::estimateSize).valueSizeComputer(DeviceCacheEntry::estimateSize).build();
        MetricService.getInstance().addMetricSet((IMetricSet)new DataNodeSchemaCacheMetrics(this));
    }

    public TimeValuePair getLastEntry(PartialPath device, String measurement) {
        DeviceCacheEntry entry = this.dualKeyCache.get(DeviceSchemaCache.getLeadingSegment(device), device);
        return Objects.nonNull(entry) ? entry.getTimeValuePair(measurement) : null;
    }

    public void invalidateDeviceLastCache(PartialPath device) {
        this.dualKeyCache.update(DeviceSchemaCache.getLeadingSegment(device), device, null, entry -> -entry.invalidateLastCache(), false);
    }

    public void putDeviceSchema(String database, DeviceSchemaInfo deviceSchemaInfo) {
        PartialPath devicePath = deviceSchemaInfo.getDevicePath();
        String databaseToUse = this.databasePool.computeIfAbsent(database, k -> database);
        this.dualKeyCache.update(DeviceSchemaCache.getLeadingSegment(devicePath), devicePath, new DeviceCacheEntry(), entry -> entry.setDeviceSchema(databaseToUse, deviceSchemaInfo), true);
    }

    public IDeviceSchema getDeviceSchema(PartialPath device) {
        DeviceCacheEntry entry = this.dualKeyCache.get(DeviceSchemaCache.getLeadingSegment(device), device);
        return Objects.nonNull(entry) ? entry.getDeviceSchema() : null;
    }

    void updateLastCache(String database, PartialPath device, String[] measurements, @Nullable TimeValuePair[] timeValuePairs, boolean isAligned, IMeasurementSchema[] measurementSchemas, boolean initOrInvalidate) {
        String database2Use = this.databasePool.computeIfAbsent(database, k -> database);
        this.dualKeyCache.update(DeviceSchemaCache.getLeadingSegment(device), device, new DeviceCacheEntry(), initOrInvalidate ? entry -> entry.setMeasurementSchema(database2Use, isAligned, measurements, measurementSchemas) + entry.initOrInvalidateLastCache(measurements, Objects.nonNull(timeValuePairs)) : entry -> entry.setMeasurementSchema(database2Use, isAligned, measurements, measurementSchemas) + entry.tryUpdateLastCache(measurements, timeValuePairs), Objects.isNull(timeValuePairs));
    }

    public boolean getLastCache(Map<String, Map<PartialPath, Map<String, TimeValuePair>>> inputMap) {
        return this.dualKeyCache.batchApply(inputMap, DeviceCacheEntry::updateInputMap);
    }

    void invalidateLastCache(PartialPath devicePath, String measurement) {
        ToIntFunction<DeviceCacheEntry> updateFunction;
        ToIntFunction<DeviceCacheEntry> toIntFunction = updateFunction = PathPatternUtil.hasWildcard((String)measurement) ? entry -> -entry.invalidateLastCache() : entry -> -entry.invalidateLastCache(measurement);
        if (!devicePath.hasWildcard()) {
            this.dualKeyCache.update(DeviceSchemaCache.getLeadingSegment(devicePath), devicePath, null, updateFunction, false);
        } else {
            this.dualKeyCache.update(segment -> {
                try {
                    return devicePath.matchPrefixPath(new PartialPath(segment));
                }
                catch (IllegalPathException e) {
                    logger.warn("Illegal segmentID {} found in cache when invalidating by path {}, invalidate it anyway", segment, (Object)devicePath);
                    return true;
                }
            }, cachedDeviceID -> cachedDeviceID.matchFullPath(devicePath), updateFunction);
        }
    }

    void invalidateCache(@Nonnull PartialPath devicePath, boolean isMultiLevelWildcardMeasurement) {
        if (!devicePath.hasWildcard()) {
            this.dualKeyCache.invalidate(DeviceSchemaCache.getLeadingSegment(devicePath), devicePath);
        } else {
            this.dualKeyCache.invalidate(segment -> {
                try {
                    return devicePath.matchPrefixPath(new PartialPath(segment));
                }
                catch (IllegalPathException e) {
                    logger.warn("Illegal segmentID {} found in cache when invalidating by path {}, invalidate it anyway", segment, (Object)devicePath);
                    return true;
                }
            }, cachedDeviceID -> isMultiLevelWildcardMeasurement ? devicePath.matchPrefixPath(cachedDeviceID) : devicePath.matchFullPath(cachedDeviceID));
        }
    }

    long getHitCount() {
        return this.dualKeyCache.stats().hitCount();
    }

    long getRequestCount() {
        return this.dualKeyCache.stats().requestCount();
    }

    public long getMemoryUsage() {
        return this.dualKeyCache.stats().memoryUsage();
    }

    long capacity() {
        return this.dualKeyCache.stats().capacity();
    }

    long entriesCount() {
        return this.dualKeyCache.stats().entriesCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateLastCache(@Nonnull String database) {
        Predicate<PartialPath> secondKeyChecker;
        try {
            PartialPath databasePath = new PartialPath(database);
            secondKeyChecker = device -> device.matchPrefixPath(databasePath);
        }
        catch (Exception ignored) {
            secondKeyChecker = device -> device.startsWith(database);
        }
        this.lock.lock();
        try {
            this.dualKeyCache.update(segment -> segment.startsWith(database), device -> true, entry -> -entry.invalidateLastCache());
            this.dualKeyCache.update(database::startsWith, secondKeyChecker, entry -> -entry.invalidateLastCache());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidate(@Nonnull String database) {
        this.lock.lock();
        try {
            this.dualKeyCache.invalidate(segment -> segment.startsWith(database), device -> true);
            this.dualKeyCache.invalidate(database::startsWith, device -> device.startsWith(database));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateLastCache() {
        this.lock.lock();
        try {
            this.dualKeyCache.update(segment -> true, device -> true, entry -> -entry.invalidateLastCache());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateSchema() {
        this.lock.lock();
        try {
            this.dualKeyCache.update(segment -> true, device -> true, entry -> -entry.invalidateSchema());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateAll() {
        this.lock.lock();
        try {
            this.dualKeyCache.invalidateAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static String getLeadingSegment(PartialPath device) {
        int lastSeparatorPos = -1;
        int separatorNum = 0;
        String deviceStr = device.getFullPath();
        for (int i = 0; i < deviceStr.length(); ++i) {
            if (deviceStr.charAt(i) != '.') continue;
            lastSeparatorPos = i;
            if (++separatorNum == 3) break;
        }
        String segment = lastSeparatorPos == -1 ? deviceStr : deviceStr.substring(0, lastSeparatorPos);
        return segment;
    }
}

