/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.bean.swagger.ExternalDocumentation;
import org.apache.juneau.bean.swagger.Items;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.bean.swagger.Xml;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class SchemaInfo
extends SwaggerElement {
    private String format;
    private String title;
    private String description;
    private String pattern;
    private String type;
    private String discriminator;
    private String ref;
    private Number multipleOf;
    private Number maximum;
    private Number minimum;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Integer maxProperties;
    private Integer minProperties;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Boolean readOnly;
    private Boolean required;
    private Object default_;
    private Object example;
    private Items items;
    private Xml xml;
    private ExternalDocumentation externalDocs;
    private Set<Object> enum_ = new LinkedHashSet<Object>();
    private Set<SchemaInfo> allOf = new LinkedHashSet<SchemaInfo>();
    private Set<String> requiredProperties = new LinkedHashSet<String>();
    private Map<String, SchemaInfo> properties = CollectionUtils.map();
    private SchemaInfo additionalProperties;

    public SchemaInfo() {
    }

    public SchemaInfo(SchemaInfo copyFrom) {
        super(copyFrom);
        SchemaInfo schemaInfo = this.additionalProperties = copyFrom.additionalProperties == null ? null : copyFrom.additionalProperties.copy();
        if (Utils.nn(copyFrom.allOf)) {
            this.allOf.addAll(CollectionUtils.copyOf(copyFrom.allOf, SchemaInfo::copy));
        }
        this.default_ = copyFrom.default_;
        this.description = copyFrom.description;
        this.discriminator = copyFrom.discriminator;
        if (Utils.nn(copyFrom.enum_)) {
            this.enum_.addAll(CollectionUtils.copyOf(copyFrom.enum_));
        }
        this.example = copyFrom.example;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.format = copyFrom.format;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.maximum = copyFrom.maximum;
        this.maxItems = copyFrom.maxItems;
        this.maxLength = copyFrom.maxLength;
        this.maxProperties = copyFrom.maxProperties;
        this.minimum = copyFrom.minimum;
        this.minItems = copyFrom.minItems;
        this.minLength = copyFrom.minLength;
        this.minProperties = copyFrom.minProperties;
        this.multipleOf = copyFrom.multipleOf;
        this.pattern = copyFrom.pattern;
        this.readOnly = copyFrom.readOnly;
        this.ref = copyFrom.ref;
        this.required = copyFrom.required;
        if (Utils.nn(copyFrom.requiredProperties)) {
            this.requiredProperties.addAll(CollectionUtils.copyOf(copyFrom.requiredProperties));
        }
        this.title = copyFrom.title;
        this.type = copyFrom.type;
        this.uniqueItems = copyFrom.uniqueItems;
        Xml xml = this.xml = copyFrom.xml == null ? null : copyFrom.xml.copy();
        if (Utils.nn(copyFrom.properties)) {
            this.properties.putAll(CollectionUtils.copyOf(copyFrom.properties, SchemaInfo::copy));
        }
    }

    public SchemaInfo addAllOf(Collection<SchemaInfo> values) {
        if (Utils.nn(values)) {
            for (SchemaInfo v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.allOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addAllOf(SchemaInfo ... values) {
        if (Utils.nn((Object)values)) {
            for (SchemaInfo v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.allOf.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addEnum(Collection<Object> values) {
        if (Utils.nn(values)) {
            this.enum_.addAll(values);
        }
        return this;
    }

    public SchemaInfo addEnum(Object ... value) {
        if (Utils.nn((Object)value)) {
            for (Object v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.enum_.add(v);
            }
        }
        return this;
    }

    public SchemaInfo addProperty(String key, SchemaInfo value) {
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        this.properties.put(key, value);
        return this;
    }

    public SchemaInfo addRequiredProperties(Collection<String> values) {
        if (Utils.nn(values)) {
            this.requiredProperties.addAll(values);
        }
        return this;
    }

    public SchemaInfo addRequiredProperties(String ... value) {
        if (Utils.nn((Object)value)) {
            for (String v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.requiredProperties.add(v);
            }
        }
        return this;
    }

    public SchemaInfo copy() {
        return new SchemaInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "additionalProperties" -> ConverterUtils.toType((Object)this.getAdditionalProperties(), type);
            case "allOf" -> ConverterUtils.toType(this.getAllOf(), type);
            case "default" -> ConverterUtils.toType((Object)this.getDefault(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "discriminator" -> ConverterUtils.toType((Object)this.getDiscriminator(), type);
            case "enum" -> ConverterUtils.toType(this.getEnum(), type);
            case "example" -> ConverterUtils.toType((Object)this.getExample(), type);
            case "exclusiveMaximum" -> ConverterUtils.toType((Object)this.getExclusiveMaximum(), type);
            case "exclusiveMinimum" -> ConverterUtils.toType((Object)this.getExclusiveMinimum(), type);
            case "externalDocs" -> ConverterUtils.toType((Object)this.getExternalDocs(), type);
            case "format" -> ConverterUtils.toType((Object)this.getFormat(), type);
            case "items" -> ConverterUtils.toType((Object)this.getItems(), type);
            case "maximum" -> ConverterUtils.toType((Object)this.getMaximum(), type);
            case "maxItems" -> ConverterUtils.toType((Object)this.getMaxItems(), type);
            case "maxLength" -> ConverterUtils.toType((Object)this.getMaxLength(), type);
            case "maxProperties" -> ConverterUtils.toType((Object)this.getMaxProperties(), type);
            case "minimum" -> ConverterUtils.toType((Object)this.getMinimum(), type);
            case "minItems" -> ConverterUtils.toType((Object)this.getMinItems(), type);
            case "minLength" -> ConverterUtils.toType((Object)this.getMinLength(), type);
            case "minProperties" -> ConverterUtils.toType((Object)this.getMinProperties(), type);
            case "multipleOf" -> ConverterUtils.toType((Object)this.getMultipleOf(), type);
            case "pattern" -> ConverterUtils.toType((Object)this.getPattern(), type);
            case "properties" -> ConverterUtils.toType(this.getProperties(), type);
            case "readOnly" -> ConverterUtils.toType((Object)this.getReadOnly(), type);
            case "$ref" -> ConverterUtils.toType((Object)this.getRef(), type);
            case "required" -> ConverterUtils.toType((Object)this.getRequired(), type);
            case "requiredProperties" -> ConverterUtils.toType(this.getRequiredProperties(), type);
            case "title" -> ConverterUtils.toType((Object)this.getTitle(), type);
            case "type" -> ConverterUtils.toType((Object)this.getType(), type);
            case "uniqueItems" -> ConverterUtils.toType((Object)this.getUniqueItems(), type);
            case "xml" -> ConverterUtils.toType((Object)this.getXml(), type);
            default -> super.get(property, type);
        });
    }

    public SchemaInfo getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Set<SchemaInfo> getAllOf() {
        return Utils.nullIfEmpty(this.allOf);
    }

    public Object getDefault() {
        return this.default_;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public Set<Object> getEnum() {
        return Utils.nullIfEmpty(this.enum_);
    }

    public Object getExample() {
        return this.example;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public String getFormat() {
        return this.format;
    }

    public Items getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Map<String, SchemaInfo> getProperties() {
        return Utils.nullIfEmpty(this.properties);
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Set<String> getRequiredProperties() {
        return Utils.nullIfEmpty(this.requiredProperties);
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Xml getXml() {
        return this.xml;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.ref), (Object)"$ref").addIf(Utils.nn((Object)this.additionalProperties), (Object)"additionalProperties").addIf(Utils.ne(this.allOf), (Object)"allOf").addIf(Utils.nn((Object)this.default_), (Object)"default").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.discriminator), (Object)"discriminator").addIf(Utils.ne(this.enum_), (Object)"enum").addIf(Utils.nn((Object)this.example), (Object)"example").addIf(Utils.nn((Object)this.exclusiveMaximum), (Object)"exclusiveMaximum").addIf(Utils.nn((Object)this.exclusiveMinimum), (Object)"exclusiveMinimum").addIf(Utils.nn((Object)this.externalDocs), (Object)"externalDocs").addIf(Utils.nn((Object)this.format), (Object)"format").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.maxProperties), (Object)"maxProperties").addIf(Utils.nn((Object)this.maximum), (Object)"maximum").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minLength), (Object)"minLength").addIf(Utils.nn((Object)this.minProperties), (Object)"minProperties").addIf(Utils.nn((Object)this.minimum), (Object)"minimum").addIf(Utils.nn((Object)this.multipleOf), (Object)"multipleOf").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.ne(this.properties), (Object)"properties").addIf(Utils.nn((Object)this.readOnly), (Object)"readOnly").addIf(Utils.nn((Object)this.required), (Object)"required").addIf(Utils.ne(this.requiredProperties), (Object)"requiredProperties").addIf(Utils.nn((Object)this.title), (Object)"title").addIf(Utils.nn((Object)this.type), (Object)"type").addIf(Utils.nn((Object)this.uniqueItems), (Object)"uniqueItems").addIf(Utils.nn((Object)this.xml), (Object)"xml").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public SchemaInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (Utils.nn((Object)this.ref)) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            SchemaInfo r = swagger.findRef(this.ref, SchemaInfo.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (Utils.nn((Object)this.items)) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        this.properties.entrySet().forEach(x -> x.setValue(((SchemaInfo)x.getValue()).resolveRefs(swagger, refStack, maxDepth)));
        if (Utils.nn((Object)this.additionalProperties)) {
            this.additionalProperties = this.additionalProperties.resolveRefs(swagger, refStack, maxDepth);
        }
        this.example = null;
        return this;
    }

    @Override
    public SchemaInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "additionalProperties" -> this.setAdditionalProperties((SchemaInfo)ConverterUtils.toType((Object)value, SchemaInfo.class));
            case "allOf" -> this.setAllOf(ConverterUtils.toSetBuilder((Object)value, SchemaInfo.class).sparse().build());
            case "default" -> this.setDefault(value);
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "discriminator" -> this.setDiscriminator(Utils.s((Object)value));
            case "enum" -> this.setEnum(value);
            case "example" -> this.setExample(value);
            case "exclusiveMaximum" -> this.setExclusiveMaximum(ConverterUtils.toBoolean((Object)value));
            case "exclusiveMinimum" -> this.setExclusiveMinimum(ConverterUtils.toBoolean((Object)value));
            case "externalDocs" -> this.setExternalDocs((ExternalDocumentation)ConverterUtils.toType((Object)value, ExternalDocumentation.class));
            case "format" -> this.setFormat(Utils.s((Object)value));
            case "items" -> this.setItems((Items)ConverterUtils.toType((Object)value, Items.class));
            case "maximum" -> this.setMaximum(ConverterUtils.toNumber((Object)value));
            case "maxItems" -> this.setMaxItems(ConverterUtils.toInteger((Object)value));
            case "maxLength" -> this.setMaxLength(ConverterUtils.toInteger((Object)value));
            case "maxProperties" -> this.setMaxProperties(ConverterUtils.toInteger((Object)value));
            case "minimum" -> this.setMinimum(ConverterUtils.toNumber((Object)value));
            case "minItems" -> this.setMinItems(ConverterUtils.toInteger((Object)value));
            case "minLength" -> this.setMinLength(ConverterUtils.toInteger((Object)value));
            case "minProperties" -> this.setMinProperties(ConverterUtils.toInteger((Object)value));
            case "multipleOf" -> this.setMultipleOf(ConverterUtils.toNumber((Object)value));
            case "pattern" -> this.setPattern(Utils.s((Object)value));
            case "properties" -> this.setProperties(ConverterUtils.toMapBuilder((Object)value, String.class, SchemaInfo.class).sparse().build());
            case "readOnly" -> this.setReadOnly(ConverterUtils.toBoolean((Object)value));
            case "$ref" -> this.setRef(Utils.s((Object)value));
            case "required" -> this.setRequired(ConverterUtils.toBoolean((Object)value));
            case "requiredProperties" -> this.setRequiredProperties(CollectionUtils.listb(String.class).addAny(new Object[]{value}).sparse().build());
            case "title" -> this.setTitle(Utils.s((Object)value));
            case "type" -> this.setType(Utils.s((Object)value));
            case "uniqueItems" -> this.setUniqueItems(ConverterUtils.toBoolean((Object)value));
            case "xml" -> this.setXml((Xml)ConverterUtils.toType((Object)value, Xml.class));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public SchemaInfo setAdditionalProperties(SchemaInfo value) {
        this.additionalProperties = value;
        return this;
    }

    public SchemaInfo setAllOf(Collection<SchemaInfo> value) {
        this.allOf.clear();
        if (Utils.nn(value)) {
            this.allOf.addAll(value);
        }
        return this;
    }

    public SchemaInfo setAllOf(SchemaInfo ... value) {
        this.setAllOf(CollectionUtils.setb(SchemaInfo.class).sparse().addAny((Object[])value).build());
        return this;
    }

    public SchemaInfo setDefault(Object value) {
        this.default_ = value;
        return this;
    }

    public SchemaInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public SchemaInfo setDiscriminator(String value) {
        this.discriminator = value;
        return this;
    }

    public SchemaInfo setEnum(Collection<Object> value) {
        this.enum_.clear();
        if (Utils.nn(value)) {
            this.enum_.addAll(value);
        }
        return this;
    }

    public SchemaInfo setEnum(Object ... value) {
        this.setEnum(CollectionUtils.setb(Object.class).sparse().addAny(value).build());
        return this;
    }

    public SchemaInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public SchemaInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public SchemaInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public SchemaInfo setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public SchemaInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public SchemaInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public SchemaInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public SchemaInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public SchemaInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public SchemaInfo setMaxProperties(Integer value) {
        this.maxProperties = value;
        return this;
    }

    public SchemaInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public SchemaInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public SchemaInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public SchemaInfo setMinProperties(Integer value) {
        this.minProperties = value;
        return this;
    }

    public SchemaInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public SchemaInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public SchemaInfo setProperties(Map<String, SchemaInfo> value) {
        this.properties.clear();
        if (Utils.nn(value)) {
            this.properties.putAll(value);
        }
        return this;
    }

    public SchemaInfo setReadOnly(Boolean value) {
        this.readOnly = value;
        return this;
    }

    @Beanp(value="$ref")
    public SchemaInfo setRef(String value) {
        this.ref = value;
        return this;
    }

    public SchemaInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public SchemaInfo setRequiredProperties(Collection<String> value) {
        this.requiredProperties.clear();
        if (Utils.nn(value)) {
            this.requiredProperties.addAll(value);
        }
        return this;
    }

    public SchemaInfo setRequiredProperties(String ... value) {
        this.setRequiredProperties(CollectionUtils.setb(String.class).sparse().addAny((Object[])value).build());
        return this;
    }

    public SchemaInfo setTitle(String value) {
        this.title = value;
        return this;
    }

    public SchemaInfo setType(String value) {
        this.type = value;
        return this;
    }

    public SchemaInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    public SchemaInfo setXml(Xml value) {
        this.xml = value;
        return this;
    }

    @Override
    public SchemaInfo strict() {
        super.strict();
        return this;
    }

    @Override
    public SchemaInfo strict(Object value) {
        super.strict(value);
        return this;
    }
}

