/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.function;

import org.apache.juneau.commons.function.Consumer5;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

@FunctionalInterface
public interface ThrowingConsumer5<A, B, C, D, E>
extends Consumer5<A, B, C, D, E> {
    @Override
    default public void apply(A a, B b, C c, D d, E e) {
        try {
            this.acceptThrows(a, b, c, d, e);
        }
        catch (Exception ex) {
            throw ThrowableUtils.toRex(ex);
        }
    }

    @Override
    default public ThrowingConsumer5<A, B, C, D, E> andThen(ThrowingConsumer5<? super A, ? super B, ? super C, ? super D, ? super E> after) {
        AssertionUtils.assertArgNotNull("after", after);
        return (a, b, c, d, e) -> {
            this.acceptThrows(a, b, c, d, e);
            after.acceptThrows(a, b, c, d, e);
        };
    }

    public void acceptThrows(A var1, B var2, C var3, D var4, E var5) throws Exception;
}

