/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.time.GranularZonedDateTime;
import org.apache.juneau.objecttools.AbstractMatcher;
import org.apache.juneau.objecttools.Equality;
import org.apache.juneau.objecttools.MatcherFactory;
import org.apache.juneau.objecttools.PatternException;

public class TimeMatcherFactory
extends MatcherFactory {
    public static final TimeMatcherFactory DEFAULT = new TimeMatcherFactory();

    protected TimeMatcherFactory() {
    }

    @Override
    public boolean canMatch(ClassMeta<?> cm) {
        return cm.isDateOrCalendar();
    }

    @Override
    public AbstractMatcher create(String pattern) {
        return new TimeMatcher(pattern);
    }

    private static class TimeMatcher
    extends AbstractMatcher {
        private static final AsciiSet DT = AsciiSet.of("0123456789-:T./");
        private static final AsciiSet WS = AsciiSet.of(" \t");
        TimestampRange[] ranges;
        List<TimestampRange> l = new LinkedList<TimestampRange>();

        public TimeMatcher(String s) {
            int i;
            StateEnum state = StateEnum.S1;
            int mark = 0;
            Equality eq = Equality.NONE;
            String s1 = null;
            String s2 = null;
            char c = '\u0000';
            for (i = 0; i < s.trim().length(); ++i) {
                c = s.charAt(i);
                if (state == StateEnum.S1) {
                    if (WS.contains(c)) {
                        state = StateEnum.S1;
                        continue;
                    }
                    if (c == '>') {
                        state = StateEnum.S2;
                        eq = Equality.GT;
                        continue;
                    }
                    if (c == '<') {
                        state = StateEnum.S3;
                        eq = Equality.LT;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateEnum.S5;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateEnum.S6;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateEnum.S8;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S2) {
                    if (WS.contains(c)) {
                        state = StateEnum.S2;
                        continue;
                    }
                    if (c == '=') {
                        state = StateEnum.S4;
                        eq = Equality.GTE;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateEnum.S5;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateEnum.S6;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateEnum.S8;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S3) {
                    if (WS.contains(c)) {
                        state = StateEnum.S3;
                        continue;
                    }
                    if (c == '=') {
                        state = StateEnum.S4;
                        eq = Equality.LTE;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateEnum.S5;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateEnum.S6;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateEnum.S8;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S4) {
                    if (WS.contains(c)) {
                        state = StateEnum.S4;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateEnum.S5;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateEnum.S6;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateEnum.S8;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S5) {
                    if (c != '\'') continue;
                    state = StateEnum.S7;
                    s1 = s.substring(mark, i);
                    continue;
                }
                if (state == StateEnum.S6) {
                    if (c != '\"') continue;
                    state = StateEnum.S7;
                    s1 = s.substring(mark, i);
                    continue;
                }
                if (state == StateEnum.S7) {
                    if (WS.contains(c)) {
                        state = StateEnum.S9;
                        continue;
                    }
                    if (c != '-') break;
                    state = StateEnum.S10;
                    continue;
                }
                if (state == StateEnum.S8) {
                    if (!WS.contains(c)) continue;
                    state = StateEnum.S9;
                    s1 = s.substring(mark, i);
                    continue;
                }
                if (state == StateEnum.S9) {
                    if (WS.contains(c)) {
                        state = StateEnum.S9;
                        continue;
                    }
                    if (c == '-') {
                        state = StateEnum.S10;
                        continue;
                    }
                    if (c == '>') {
                        state = StateEnum.S2;
                        this.l.add(new TimestampRange(eq, s1));
                        eq = Equality.GT;
                        s1 = null;
                        continue;
                    }
                    if (c == '<') {
                        state = StateEnum.S3;
                        this.l.add(new TimestampRange(eq, s1));
                        eq = Equality.LT;
                        s1 = null;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateEnum.S5;
                        this.l.add(new TimestampRange(eq, s1));
                        mark = i + 1;
                        eq = null;
                        s1 = null;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateEnum.S6;
                        this.l.add(new TimestampRange(eq, s1));
                        mark = i + 1;
                        eq = null;
                        s1 = null;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateEnum.S8;
                    this.l.add(new TimestampRange(eq, s1));
                    eq = null;
                    s1 = null;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S10) {
                    if (WS.contains(c)) {
                        state = StateEnum.S10;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateEnum.S11;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateEnum.S12;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateEnum.S13;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S11) {
                    if (c != '\'') continue;
                    state = StateEnum.S1;
                    s2 = s.substring(mark, i);
                    this.l.add(new TimestampRange(s1, s2));
                    s1 = null;
                    s2 = null;
                    continue;
                }
                if (state == StateEnum.S12) {
                    if (c != '\"') continue;
                    state = StateEnum.S1;
                    s2 = s.substring(mark, i);
                    this.l.add(new TimestampRange(s1, s2));
                    s1 = null;
                    s2 = null;
                    continue;
                }
                if (!WS.contains(c)) continue;
                state = StateEnum.S1;
                s2 = s.substring(mark, i);
                this.l.add(new TimestampRange(s1, s2));
                s1 = null;
                s2 = null;
            }
            if (i != s.length()) {
                throw new PatternException("Invalid range pattern ({0}): pattern=[{1}], pos=[{2}], char=[{3}]", new Object[]{state, s, i, Character.valueOf(c)});
            }
            if (state != StateEnum.S1) {
                if (state == StateEnum.S2 || state == StateEnum.S3 || state == StateEnum.S4 || state == StateEnum.S5 || state == StateEnum.S6 || state == StateEnum.S10 || state == StateEnum.S11 || state == StateEnum.S12) {
                    throw new PatternException("Invalid range pattern (E{0}): {1}", new Object[]{state, s});
                }
                if (state == StateEnum.S7) {
                    this.l.add(new TimestampRange(eq, s1));
                } else if (state == StateEnum.S8) {
                    s1 = s.substring(mark).trim();
                    this.l.add(new TimestampRange(eq, s1));
                } else {
                    s2 = s.substring(mark).trim();
                    this.l.add(new TimestampRange(s1, s2));
                }
            }
            this.ranges = this.l.toArray(new TimestampRange[this.l.size()]);
        }

        @Override
        public boolean matches(ClassMeta<?> cm, Object o) {
            if (this.ranges.length == 0) {
                return true;
            }
            ZonedDateTime zdt = null;
            if (cm.isCalendar()) {
                Calendar c = (Calendar)o;
                zdt = c.toInstant().atZone(c.getTimeZone().toZoneId());
            } else {
                Date date = (Date)o;
                zdt = date.toInstant().atZone(ZoneId.systemDefault());
            }
            for (TimestampRange range : this.ranges) {
                if (!range.matches(zdt)) continue;
                return true;
            }
            return false;
        }
    }

    private static class TimestampRange {
        ZonedDateTime start;
        ZonedDateTime end;

        public TimestampRange(Equality eq, String singleDate) {
            GranularZonedDateTime singleDate1 = GranularZonedDateTime.of(singleDate);
            if (eq == Equality.GT) {
                this.start = singleDate1.roll(1).roll(ChronoField.MILLI_OF_SECOND, -1).getZonedDateTime();
                this.end = Instant.ofEpochMilli(Long.MAX_VALUE).atZone(ZoneId.systemDefault());
            } else if (eq == Equality.LT) {
                this.start = Instant.ofEpochMilli(0L).atZone(ZoneId.systemDefault());
                this.end = singleDate1.getZonedDateTime();
            } else if (eq == Equality.GTE) {
                this.start = singleDate1.roll(ChronoField.MILLI_OF_SECOND, -1).getZonedDateTime();
                this.end = Instant.ofEpochMilli(Long.MAX_VALUE).atZone(ZoneId.systemDefault());
            } else if (eq == Equality.LTE) {
                this.start = Instant.ofEpochMilli(0L).atZone(ZoneId.systemDefault());
                this.end = singleDate1.roll(1).getZonedDateTime();
            } else {
                this.start = singleDate1.copy().roll(ChronoField.MILLI_OF_SECOND, -1).getZonedDateTime();
                this.end = singleDate1.roll(1).getZonedDateTime();
            }
        }

        public TimestampRange(String start, String end) {
            GranularZonedDateTime start1 = GranularZonedDateTime.of(start);
            GranularZonedDateTime end1 = GranularZonedDateTime.of(end);
            this.start = start1.copy().roll(ChronoField.MILLI_OF_SECOND, -1).getZonedDateTime();
            this.end = end1.roll(1).getZonedDateTime();
        }

        public boolean matches(ZonedDateTime zdt) {
            return zdt.isAfter(this.start) && zdt.isBefore(this.end);
        }
    }
}

