/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.response.BasicHttpException;

@Response
@StatusCode(value={400})
@Schema(description={"Bad Request"})
public class BadRequest
extends BasicHttpException {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 400;
    public static final String REASON_PHRASE = "Bad Request";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create(400, "Bad Request");
    public static final BadRequest INSTANCE = new BadRequest().setUnmodifiable();

    public BadRequest() {
        this((Throwable)null, REASON_PHRASE, new Object[0]);
    }

    public BadRequest(HttpResponse response) {
        super(response);
        this.assertStatusCode(response);
    }

    public BadRequest(String msg, Object ... args) {
        this((Throwable)null, msg, args);
    }

    public BadRequest(Throwable cause) {
        this(cause, cause == null ? REASON_PHRASE : cause.getMessage(), new Object[0]);
    }

    public BadRequest(Throwable cause, String msg, Object ... args) {
        super(400, cause, msg, args);
        this.setStatusLine(STATUS_LINE.copy());
    }

    protected BadRequest(BadRequest copyFrom) {
        super(copyFrom);
    }

    public BadRequest copy() {
        return new BadRequest(this);
    }

    @Override
    public BadRequest setContent(HttpEntity value) {
        super.setContent(value);
        return this;
    }

    @Override
    public BadRequest setContent(String value) {
        super.setContent(value);
        return this;
    }

    @Override
    public BadRequest setHeader2(String name, Object value) {
        super.setHeader2(name, value);
        return this;
    }

    @Override
    public BadRequest setHeaders(HeaderList value) {
        super.setHeaders(value);
        return this;
    }

    @Override
    public BadRequest setHeaders(List<Header> values) {
        super.setHeaders(values);
        return this;
    }

    @Override
    public BadRequest setHeaders2(Header ... values) {
        super.setHeaders2(values);
        return this;
    }

    @Override
    public BadRequest setLocale2(Locale value) {
        super.setLocale2(value);
        return this;
    }

    @Override
    public BadRequest setMessage(String message, Object ... args) {
        super.setMessage(message, args);
        return this;
    }

    @Override
    public BadRequest setProtocolVersion(ProtocolVersion value) {
        super.setProtocolVersion(value);
        return this;
    }

    @Override
    public BadRequest setReasonPhrase2(String value) {
        super.setReasonPhrase2(value);
        return this;
    }

    @Override
    public BadRequest setReasonPhraseCatalog(ReasonPhraseCatalog value) {
        super.setReasonPhraseCatalog(value);
        return this;
    }

    @Override
    public BadRequest setStatusCode2(int code) throws IllegalStateException {
        super.setStatusCode2(code);
        return this;
    }

    @Override
    public BadRequest setStatusLine(BasicStatusLine value) {
        super.setStatusLine(value);
        return this;
    }

    @Override
    public BadRequest setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }
}

