/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.http.NameValuePair;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHttpPart;

public class RequestFormParam
extends RequestHttpPart
implements NameValuePair {
    private final Part part;

    public RequestFormParam(RestRequest request, Part part) {
        super(HttpPartType.FORMDATA, request, part.getName(), null);
        this.part = part;
    }

    public RequestFormParam(RestRequest request, String name, String value) {
        super(HttpPartType.FORMDATA, request, name, value);
        this.part = null;
    }

    @Override
    public RequestFormParam def(String def) {
        super.def(def);
        return this;
    }

    public String getContentType() {
        return this.part == null ? null : this.part.getContentType();
    }

    public String getHeader(String name) {
        return this.part.getHeader(name);
    }

    public Collection<String> getHeaderNames() {
        return this.part.getHeaderNames();
    }

    public Collection<String> getHeaders(String name) {
        return this.part.getHeaders(name);
    }

    public long getSize() {
        return this.part.getSize();
    }

    public InputStream getStream() throws IOException {
        if (Utils.nn(this.value)) {
            return new ByteArrayInputStream(this.value.getBytes(IoUtils.UTF8));
        }
        return this.part.getInputStream();
    }

    public String getSubmittedFileName() {
        return this.part.getSubmittedFileName();
    }

    @Override
    public String getValue() {
        if (this.value == null && Utils.nn(this.part)) {
            try {
                this.value = IoUtils.read(this.part.getInputStream());
            }
            catch (IOException e) {
                throw ThrowableUtils.toRex(e);
            }
        }
        return this.value;
    }

    @Override
    public RequestFormParam parser(HttpPartParserSession value) {
        super.parser(value);
        return this;
    }

    @Override
    public RequestFormParam schema(HttpPartSchema value) {
        super.schema(value);
        return this;
    }
}

