/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.beans;

import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.http.annotation.Response;

@Bean(properties="name,description", findFluentSetters=true)
@Response(schema=@Schema(ignore=true))
public class ResourceDescription
implements Comparable<ResourceDescription> {
    private String name;
    private String uri;
    private String description;

    public ResourceDescription() {
    }

    public ResourceDescription(String name, String description) {
        this.name = name;
        this.uri = name;
        this.description = description;
    }

    public ResourceDescription(String name, String uri, String description) {
        this.name = name;
        this.uri = uri;
        this.description = description;
    }

    @Override
    public int compareTo(ResourceDescription o) {
        return this.getName().toString().compareTo(o.getName().toString());
    }

    public ResourceDescription description(String description) {
        this.description = description;
        return this;
    }

    public boolean equals(Object o) {
        ResourceDescription o2;
        return o instanceof ResourceDescription && Utils.eq((Object)this, (Object)(o2 = (ResourceDescription)o), (x, y) -> Utils.eq((Object)x.getName(), (Object)y.getName()));
    }

    public String getDescription() {
        return this.description;
    }

    @Html(link="servlet:/{uri}")
    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri == null ? this.name : this.uri;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public ResourceDescription name(String name) {
        this.name = name;
        return this;
    }

    public ResourceDescription uri(String uri) {
        this.uri = uri;
        return this;
    }
}

